
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
hours_worked_by_jean = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_jean")
hours_worked_by_mary = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_mary")

# Objective function
m.setObjective(8.91 * hours_worked_by_jean * hours_worked_by_mary + 3.63 * hours_worked_by_jean + 2.92 * hours_worked_by_mary, GRB.MINIMIZE)

# Constraints
# Minimum combined dollar cost per hour
m.addConstr(14 * hours_worked_by_jean + 14 * hours_worked_by_mary >= 39, name="min_dollar_cost")

# Minimum combined likelihood to quit index
m.addConstr(11 * hours_worked_by_jean + 7 * hours_worked_by_mary >= 61, name="min_quit_index")

# Constraint on hours worked by Jean and Mary
m.addConstr(10 * hours_worked_by_jean**2 - 2 * hours_worked_by_mary**2 >= 0, name="hours_constraint")

# Maximum combined dollar cost per hour squared
m.addConstr((14 * hours_worked_by_jean)**2 + (14 * hours_worked_by_mary)**2 <= 87, name="max_dollar_cost_squared")

# Maximum combined likelihood to quit index
m.addConstr(11 * hours_worked_by_jean + 7 * hours_worked_by_mary <= 77, name="max_quit_index")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Jean:", hours_worked_by_jean.x)
    print("Hours worked by Mary:", hours_worked_by_mary.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found")
