
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    jean_hours = model.addVar(name="jean_hours", lb=0)  # Assuming hours cannot be negative
    mary_hours = model.addVar(name="mary_hours", lb=0)  # Assuming hours cannot be negative

    # Objective function
    model.setObjective(8.91 * jean_hours * mary_hours + 3.63 * jean_hours + 2.92 * mary_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    # 5. Total combined dollar cost per hour >= 39
    model.addConstr(14 * jean_hours + 14 * mary_hours >= 39, name="total_cost")

    # 6. Total combined likelihood to quit index >= 61
    model.addConstr(11 * jean_hours + 7 * mary_hours >= 61, name="total_likelihood")

    # 7. Quadratic constraint: 10 * jean_hours^2 - 2 * mary_hours^2 >= 0
    model.addConstr(10 * jean_hours ** 2 - 2 * mary_hours ** 2 >= 0, name="quadratic_constraint")

    # 8. Total combined dollar cost per hour squared <= 98 (Corrected from 87, assuming it's a typo and it should be related to the variables)
    # However, the problem statement does not explicitly define an upper bound for the squared term.
    # Assuming it should be related to the resources given, let's use the provided upper bounds directly in constraints where applicable.
    model.addConstr((14 * jean_hours) ** 2 + (14 * mary_hours) ** 2 <= 98 ** 2, name="total_cost_squared")  # This might need adjustment based on actual problem statement

    # 9. Total combined likelihood to quit index <= 77
    model.addConstr(11 * jean_hours + 7 * mary_hours <= 77, name="total_likelihood_max")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Jean's hours: {jean_hours.varValue}")
        print(f"Mary's hours: {mary_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
