
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize_Work_Hours")

# Create variables
laura_hours = model.addVar(vtype=GRB.CONTINUOUS, name="laura_hours")
hank_hours = model.addVar(vtype=GRB.CONTINUOUS, name="hank_hours")
mary_hours = model.addVar(vtype=GRB.CONTINUOUS, name="mary_hours")

# Set objective function
model.setObjective(2.81 * laura_hours + 5.39 * hank_hours + 8.18 * mary_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(23.08 * laura_hours >= 0, "Laura_likelihood_quit_index")  # Redundant constraint
model.addConstr(20.84 * laura_hours >= 0, "Laura_organization_score")  # Redundant constraint
model.addConstr(9.62 * hank_hours >= 0, "Hank_likelihood_quit_index")  # Redundant constraint
model.addConstr(17.17 * hank_hours >= 0, "Hank_organization_score")  # Redundant constraint
model.addConstr(8.92 * mary_hours >= 0, "Mary_likelihood_quit_index")  # Redundant constraint
model.addConstr(20.23 * mary_hours >= 0, "Mary_organization_score")  # Redundant constraint

model.addConstr(23.08 * laura_hours + 9.62 * hank_hours >= 20, "Combined_likelihood_Laura_Hank")
model.addConstr(23.08 * laura_hours + 9.62 * hank_hours + 8.92 * mary_hours >= 20, "Combined_likelihood_all")
model.addConstr(20.84 * laura_hours + 17.17 * hank_hours >= 23, "Combined_organization_Laura_Hank")
model.addConstr(20.84 * laura_hours + 20.23 * mary_hours >= 44, "Combined_organization_Laura_Mary")
model.addConstr(20.84 * laura_hours + 17.17 * hank_hours + 20.23 * mary_hours >= 44, "Combined_organization_all")
model.addConstr(20.84 * laura_hours + 17.17 * hank_hours + 20.23 * mary_hours <= 150, "Combined_organization_all_upper_bound")


model.addConstr(-10 * hank_hours + 5 * mary_hours >= 0, "Hank_Mary_constraint")
model.addConstr(-8 * laura_hours + 1 * hank_hours >= 0, "Laura_Hank_constraint")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('Laura Hours: %g' % laura_hours.x)
    print('Hank Hours: %g' % hank_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

