
from gurobipy import *

# Create a new model
m = Model("Work_Hours_Optimization")

# Decision variables: hours worked by each person
L = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")
H = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Hank")
M = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Mary")

# Objective function: minimize
m.setObjective(2.81*L + 5.39*H + 8.18*M, GRB.MINIMIZE)

# Constraints
# Likelihood to quit index constraints (note: these seem to be individual properties rather than constraints)
# Thus, they might not directly translate into constraints but could influence the objective or other constraints

# Total combined likelihood to quit index from hours worked by Laura plus hours worked by Hank >= 20
m.addConstr(23.08*L + 9.62*H >= 20, name="likelihood_to_quit_index_LH")

# Total combined likelihood to quit index from hours worked by Laura, hours worked by Hank, and hours worked by Mary >= 20
m.addConstr(23.08*L + 9.62*H + 8.92*M >= 20, name="likelihood_to_quit_index_LHM")

# Organization score constraints
# Total combined organization score from hours worked by Laura and hours worked by Hank >= 23
m.addConstr(20.84*L + 17.17*H >= 23, name="organization_score_LH")

# Total combined organization score from hours worked by Laura and hours worked by Mary >= 44
m.addConstr(20.84*L + 20.23*M >= 44, name="organization_score_LM")

# Total combined organization score from hours worked by Laura, hours worked by Hank, and hours worked by Mary >= 44
m.addConstr(20.84*L + 17.17*H + 20.23*M >= 44, name="organization_score_LHM")

# Additional constraints
# -10 times the number of hours worked by Hank plus 5 times the number of hours worked by Mary >= 0
m.addConstr(-10*H + 5*M >= 0, name="additional_constraint_1")

# -8 times the number of hours worked by Laura plus 1 times the number of hours worked by Hank >= 0
m.addConstr(-8*L + H >= 0, name="additional_constraint_2")

# Total combined organization score from hours worked by Laura, hours worked by Hank, and hours worked by Mary <= 150
m.addConstr(20.84*L + 17.17*H + 20.23*M <= 150, name="organization_score_LHM_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Hours worked by Laura: {L.x}")
    print(f"Hours worked by Hank: {H.x}")
    print(f"Hours worked by Mary: {M.x}")
else:
    print("No optimal solution found")
