
import gurobi

def optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    laura_hours = model.addVar(name="laura_hours", lb=0)  # Assuming hours cannot be negative
    hank_hours = model.addVar(name="hank_hours", lb=0)
    mary_hours = model.addVar(name="mary_hours", lb=0)

    # Define parameters
    r0_x0, r0_x1, r0_x2 = 23.08, 9.62, 8.92
    r1_x0, r1_x1, r1_x2 = 20.84, 17.17, 20.23

    # Objective function
    model.setObjective(2.81 * laura_hours + 5.39 * hank_hours + 8.18 * mary_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(r0_x0 * laura_hours + r0_x1 * hank_hours >= 20, name="likelihood_laura_hank")
    model.addConstr(r0_x0 * laura_hours + r0_x1 * hank_hours + r0_x2 * mary_hours >= 20, name="likelihood_all")
    model.addConstr(r1_x0 * laura_hours + r1_x1 * hank_hours >= 23, name="organization_laura_hank")
    model.addConstr(r1_x0 * laura_hours + r1_x2 * mary_hours >= 44, name="organization_laura_mary")
    model.addConstr(r1_x0 * laura_hours + r1_x1 * hank_hours + r1_x2 * mary_hours >= 44, name="organization_all_min")
    model.addConstr(r1_x0 * laura_hours + r1_x1 * hank_hours + r1_x2 * mary_hours <= 150, name="organization_all_max")
    model.addConstr(-10 * hank_hours + 5 * mary_hours >= 0, name="hank_mary_constraint")
    model.addConstr(-8 * laura_hours + 1 * hank_hours >= 0, name="laura_hank_constraint")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Laura hours: {laura_hours.varValue}")
        print(f"Hank hours: {hank_hours.varValue}")
        print(f"Mary hours: {mary_hours.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimization_problem()
