
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
peggy = model.addVar(vtype=GRB.CONTINUOUS, name="Peggy")  # Peggy's hours, can be fractional
laura = model.addVar(vtype=GRB.INTEGER, name="Laura")  # Laura's hours, integer
george = model.addVar(vtype=GRB.CONTINUOUS, name="George") # George's hours, can be fractional
mary = model.addVar(vtype=GRB.INTEGER, name="Mary")  # Mary's hours, integer


# Set objective function
model.setObjective(7.35 * peggy + 3.76 * laura + 4.62 * george + 9.64 * mary, GRB.MINIMIZE)

# Add constraints
model.addConstr(22 * peggy + 4 * george >= 49, "c1")
model.addConstr(22 * peggy + 16 * mary >= 66, "c2")
model.addConstr(10 * laura + 16 * mary >= 72, "c3")
model.addConstr(10 * laura + 4 * george + 16 * mary >= 71, "c4")
model.addConstr(22 * peggy + 10 * laura + 16 * mary >= 71, "c5")
model.addConstr(10 * laura + 4 * george + 16 * mary >= 69, "c6")
model.addConstr(22 * peggy + 10 * laura + 16 * mary >= 69, "c7")
model.addConstr(22 * peggy + 10 * laura + 4 * george + 16 * mary >= 69, "c8")
model.addConstr(10 * peggy - 3 * mary >= 0, "c9")
model.addConstr(5 * george - 5 * mary >= 0, "c10")


# Optimize model
model.optimize()

# Check for infeasibility
if model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    # Print results
    print("Optimal Solution:")
    for v in model.getVars():
        print(f"{v.varName}: {v.x}")
    print(f"Objective Value: {model.objVal}")

