
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    P = model.addVar(name="Peggy", lb=0)  # hours worked by Peggy
    L = model.addVar(name="Laura", lb=0)  # hours worked by Laura
    G = model.addVar(name="George", lb=0)  # hours worked by George
    M = model.addVar(name="Mary", lb=0, vtype=gurobi.GRB.INTEGER)  # hours worked by Mary

    # Objective function
    model.setObjective(7.35 * P + 3.76 * L + 4.62 * G + 9.64 * M, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(22 * P + 4 * G >= 49, name="Constraint_1")
    model.addConstr(22 * P + 16 * M >= 66, name="Constraint_2")
    model.addConstr(10 * L + 16 * M >= 72, name="Constraint_3")
    model.addConstr(10 * L + 4 * G + 16 * M >= 71, name="Constraint_4")
    model.addConstr(22 * P + 10 * L + 16 * M >= 71, name="Constraint_5")
    model.addConstr(10 * L + 4 * G + 16 * M >= 69, name="Constraint_6")
    model.addConstr(22 * P + 10 * L + 16 * M >= 69, name="Constraint_7")
    model.addConstr(22 * P + 10 * L + 4 * G + 16 * M >= 69, name="Constraint_8")
    model.addConstr(10 * P - 3 * M >= 0, name="Constraint_9")
    model.addConstr(5 * G - 5 * M >= 0, name="Constraint_10")

    # Optimize the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Peggy: ", P.varValue)
        print("Laura: ", L.varValue)
        print("George: ", G.varValue)
        print("Mary: ", M.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
