
from gurobipy import Model, GRB

# Create a new model
model = Model("Nutrition Optimization")

# Create variables
vitamin_b1 = model.addVar(vtype=GRB.INTEGER, name="vitamin_b1")
iron = model.addVar(vtype=GRB.CONTINUOUS, name="iron")
protein = model.addVar(vtype=GRB.INTEGER, name="protein")
vitamin_a = model.addVar(vtype=GRB.INTEGER, name="vitamin_a")

# Set objective function
model.setObjective(1 * vitamin_b1 + 9 * iron + 9 * protein + 2 * vitamin_a, GRB.MAXIMIZE)

# Add constraints
model.addConstr(9 * iron + 5 * protein >= 33, "c1")
model.addConstr(5 * protein + 3 * vitamin_a <= 108, "c2")
model.addConstr(1 * vitamin_b1 + 5 * protein <= 181, "c3")
model.addConstr(1 * vitamin_b1 + 9 * iron + 5 * protein <= 158, "c4")
model.addConstr(1 * vitamin_b1 + 5 * protein + 3 * vitamin_a <= 177, "c5")
model.addConstr(9 * iron + 5 * protein + 3 * vitamin_a <= 123, "c6")
model.addConstr(1 * vitamin_b1 + 9 * iron + 3 * vitamin_a <= 141, "c7")
model.addConstr(1 * vitamin_b1 + 9 * iron + 5 * protein + 3 * vitamin_a <= 141, "c8")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('vitamin_b1:', vitamin_b1.x)
    print('iron:', iron.x)
    print('protein:', protein.x)
    print('vitamin_a:', vitamin_a.x)
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % model.status)

