
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the variables
x0 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_B1")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="milligrams_of_iron")
x2 = m.addVar(vtype=GRB.INTEGER, name="grams_of_protein")
x3 = m.addVar(vtype=GRB.INTEGER, name="milligrams_of_vitamin_A")

# Objective function
m.setObjective(1*x0 + 9*x1 + 5*x2 + 2*x3, GRB.MAXIMIZE)

# Constraints
m.addConstr(x1 + x2 >= 33)  # Minimum total cognitive performance index from x1 and x2 is 33
m.addConstr(x2 + x3 <= 108)  # Maximum total cognitive performance index from x2 and x3 is 108
m.addConstr(x0 + x2 <= 181)  # Maximum total cognitive performance index from x0 and x2 is 181
m.addConstr(x0 + x1 + x2 <= 158)  # Maximum total cognitive performance index from x0, x1, and x2 is 158
m.addConstr(x0 + x2 + x3 <= 177)  # Maximum total cognitive performance index from x0, x2, and x3 is 177
m.addConstr(x1 + x2 + x3 <= 123)  # Maximum total cognitive performance index from x1, x2, and x3 is 123
m.addConstr(x0 + x1 + x3 <= 141)  # Maximum total cognitive performance index from x0, x1, and x3 is 141
m.addConstr(x0 + x1 + x2 + x3 <= 141)  # Maximum total cognitive performance index from all nutrients is 141

# Solve the model
m.optimize()

# Print solution
for v in m.getVars():
    print(f"{v.varName}: {v.x}")

print(f"Objective: {m.objVal}")
