
import gurobi

def optimize_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    vitamin_B1 = model.addVar(name="vitamin_B1", vtype=gurobi.GRB.INTEGER)  # mg, whole number
    iron = model.addVar(name="iron", vtype=gurobi.GRB.CONTINUOUS)  # mg
    protein = model.addVar(name="protein", vtype=gurobi.GRB.INTEGER)  # grams, whole number
    vitamin_A = model.addVar(name="vitamin_A", vtype=gurobi.GRB.INTEGER)  # mg, non-fractional

    # Objective function
    model.setObjective(vitamin_B1 + 9 * iron + 9 * protein + 2 * vitamin_A, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(vitamin_B1 <= 184)  # Cognitive performance index limit for vitamin B1
    model.addConstr(9 * iron <= 184)  # Cognitive performance index limit for iron
    model.addConstr(5 * protein <= 184)  # Cognitive performance index limit for protein
    model.addConstr(3 * vitamin_A <= 184)  # Cognitive performance index limit for vitamin A

    # Constraint 5: 9*iron + 5*protein >= 33
    model.addConstr(9 * iron + 5 * protein >= 33)

    # Constraint 6: 5*protein + 3*vitamin_A <= 108
    model.addConstr(5 * protein + 3 * vitamin_A <= 108)

    # Constraint 7: vitamin_B1 + 5*protein <= 181
    model.addConstr(vitamin_B1 + 5 * protein <= 181)

    # Constraint 8: vitamin_B1 + 9*iron + 5*protein <= 158
    model.addConstr(vitamin_B1 + 9 * iron + 5 * protein <= 158)

    # Constraint 9: vitamin_B1 + 5*protein + 3*vitamin_A <= 177
    model.addConstr(vitamin_B1 + 5 * protein + 3 * vitamin_A <= 177)

    # Constraint 10: 9*iron + 5*protein + 3*vitamin_A <= 123
    model.addConstr(9 * iron + 5 * protein + 3 * vitamin_A <= 123)

    # Constraint 11: vitamin_B1 + 9*iron + 3*vitamin_A <= 141
    model.addConstr(vitamin_B1 + 9 * iron + 3 * vitamin_A <= 141)

    # Constraint 12: vitamin_B1 + 9*iron + 5*protein + 3*vitamin_A <= 141
    model.addConstr(vitamin_B1 + 9 * iron + 5 * protein + 3 * vitamin_A <= 141)

    # Solve the problem
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Vitamin B1: {vitamin_B1.varValue}")
        print(f"Iron: {iron.varValue}")
        print(f"Protein: {protein.varValue}")
        print(f"Vitamin A: {vitamin_A.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
