
import gurobipy as gp

# Create a new model
m = gp.Model("employee_scheduling")

# Create variables
mary_hours = m.addVar(name="mary_hours")
peggy_hours = m.addVar(name="peggy_hours")

# Set objective function
m.setObjective(6.86 * mary_hours + 6.82 * peggy_hours, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * mary_hours + 3 * peggy_hours >= 27, "paperwork_min")
m.addConstr(5 * mary_hours + 12 * peggy_hours >= 25, "computer_min")
m.addConstr(4 * mary_hours + 9 * peggy_hours >= 23, "cost_min")
m.addConstr(7 * mary_hours + 9 * peggy_hours >= 18, "quality_min")
m.addConstr(12 * mary_hours + 13 * peggy_hours >= 36, "productivity_min")
m.addConstr(mary_hours - 10 * peggy_hours >= 0, "mary_peggy_relation")

m.addConstr(14 * mary_hours + 3 * peggy_hours <= 68, "paperwork_max")
m.addConstr(5 * mary_hours + 12 * peggy_hours <= 103, "computer_max")
m.addConstr(4 * mary_hours + 9 * peggy_hours <= 54, "cost_max")
m.addConstr(7 * mary_hours + 9 * peggy_hours <= 49, "quality_max")
m.addConstr(12 * mary_hours + 13 * peggy_hours <= 53, "productivity_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Optimal solution found')
    print(f"Mary's hours: {mary_hours.x}")
    print(f"Peggy's hours: {peggy_hours.x}")
    print(f"Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print(f"Optimization ended with status {m.status}")

