
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
M = m.addVar(name="hours_worked_by_Mary", lb=0)  # hours worked by Mary
P = m.addVar(name="hours_worked_by_Peggy", lb=0)  # hours worked by Peggy

# Define the objective function
m.setObjective(6.86 * M + 6.82 * P, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(14 * M + 3 * P >= 27, name="paperwork_1")
m.addConstr(5 * M + 12 * P >= 25, name="computer_1")
m.addConstr(4 * M + 9 * P >= 23, name="dollar_cost_1")
m.addConstr(7 * M + 9 * P >= 18, name="work_quality_1")
m.addConstr(12 * M + 13 * P >= 36, name="productivity_1")
m.addConstr(M - 10 * P >= 0, name="additional_constraint")
m.addConstr(14 * M + 3 * P <= 68, name="paperwork_2")
m.addConstr(5 * M + 12 * P <= 103, name="computer_2")
m.addConstr(4 * M + 9 * P <= 54, name="dollar_cost_2")
m.addConstr(7 * M + 9 * P <= 49, name="work_quality_2")
m.addConstr(12 * M + 13 * P <= 53, name="productivity_2")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Mary: {M.varValue}")
    print(f"Hours worked by Peggy: {P.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
