
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
cantaloupes = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cantaloupes")
lemons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="lemons")
ham_sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="ham_sandwiches")
strawberries = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="strawberries")

# Set objective function
m.setObjective(7.05 * cantaloupes + 1.79 * lemons + 9.61 * ham_sandwiches + 3.42 * strawberries, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(29 * cantaloupes + 19 * strawberries >= 62, "tastiness_constr1")
m.addConstr(lemons + 23 * ham_sandwiches >= 62, "tastiness_constr2")
m.addConstr(23 * ham_sandwiches + 19 * strawberries >= 80, "tastiness_constr3")
m.addConstr(lemons + 23 * ham_sandwiches + 19 * strawberries >= 104, "tastiness_constr4")
m.addConstr(29 * cantaloupes + lemons + 23 * ham_sandwiches >= 104, "tastiness_constr5")
m.addConstr(29 * cantaloupes + lemons + 19 * strawberries >= 104, "tastiness_constr6")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 104, "tastiness_constr7")
m.addConstr(lemons + 23 * ham_sandwiches + 19 * strawberries >= 95, "tastiness_constr8")
m.addConstr(29 * cantaloupes + lemons + 23 * ham_sandwiches >= 95, "tastiness_constr9")
m.addConstr(29 * cantaloupes + lemons + 19 * strawberries >= 95, "tastiness_constr10")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 95, "tastiness_constr11")
m.addConstr(lemons + 23 * ham_sandwiches + 19 * strawberries >= 57, "tastiness_constr12")
m.addConstr(29 * cantaloupes + lemons + 23 * ham_sandwiches >= 57, "tastiness_constr13")
m.addConstr(29 * cantaloupes + lemons + 19 * strawberries >= 57, "tastiness_constr14")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 57, "tastiness_constr15")
m.addConstr(lemons + 23 * ham_sandwiches + 19 * strawberries >= 108, "tastiness_constr16")
m.addConstr(29 * cantaloupes + lemons + 23 * ham_sandwiches >= 108, "tastiness_constr17")
m.addConstr(29 * cantaloupes + lemons + 19 * strawberries >= 108, "tastiness_constr18")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 108, "tastiness_constr19")
m.addConstr(29 * cantaloupes + lemons + 23 * ham_sandwiches + 19 * strawberries >= 108, "tastiness_constr20")

m.addConstr(7 * cantaloupes + 6 * ham_sandwiches >= 45, "protein_constr1")
m.addConstr(7 * lemons + 6 * ham_sandwiches >= 24, "protein_constr2")
m.addConstr(7 * cantaloupes + 26 * strawberries >= 30, "protein_constr3")
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 40, "protein_constr4")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 40, "protein_constr5")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 40, "protein_constr6")
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 41, "protein_constr7")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 41, "protein_constr8")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 41, "protein_constr9")
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 31, "protein_constr10")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 31, "protein_constr11")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31, "protein_constr12")
m.addConstr(7 * cantaloupes + 7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31, "protein_constr13")


m.addConstr(9 * cantaloupes - 2 * strawberries >= 0, "additional_constr1")
m.addConstr(-3 * ham_sandwiches + 9 * strawberries >= 0, "additional_constr2")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

