
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables (can be fractional)
x0 = m.addVar(name="cantaloupes", lb=0, vtype=GRB.CONTINUOUS)
x1 = m.addVar(name="lemons", lb=0, vtype=GRB.CONTINUOUS)
x2 = m.addVar(name="ham_sandwiches", lb=0, vtype=GRB.CONTINUOUS)
x3 = m.addVar(name="strawberries", lb=0, vtype=GRB.CONTINUOUS)

# Define the objective function
m.setObjective(7.05*x0 + 1.79*x1 + 9.61*x2 + 3.42*x3, GRB.MINIMIZE)

# Add constraints based on tastiness ratings and protein content
m.addConstr(29*x0 + 19*x3 >= 62)
m.addConstr(x1 + 23*x2 >= 62)
m.addConstr(23*x2 + 19*x3 >= 80)
m.addConstr(x1 + 23*x2 + 19*x3 >= 104)
m.addConstr(29*x0 + x1 + 23*x2 >= 104)
m.addConstr(29*x0 + x1 + 19*x3 >= 104)
m.addConstr(29*x0 + 23*x2 + 19*x3 >= 104)
m.addConstr(x1 + 23*x2 + 19*x3 >= 95)
m.addConstr(29*x0 + x1 + 23*x2 >= 95)
m.addConstr(29*x0 + x1 + 19*x3 >= 95)
m.addConstr(29*x0 + 23*x2 + 19*x3 >= 95)
m.addConstr(x1 + 23*x2 + 19*x3 >= 57)
m.addConstr(29*x0 + x1 + 23*x2 >= 57)
m.addConstr(29*x0 + x1 + 19*x3 >= 57)
m.addConstr(29*x0 + 23*x2 + 19*x3 >= 57)
m.addConstr(x1 + 23*x2 + 19*x3 >= 108)
m.addConstr(29*x0 + x1 + 23*x2 >= 108)
m.addConstr(29*x0 + x1 + 19*x3 >= 108)
m.addConstr(29*x0 + 23*x2 + 19*x3 >= 108)
m.addConstr(29*x0 + x1 + 23*x2 + 19*x3 >= 108)

# Add protein content constraints
m.addConstr(7*x0 + 6*x2 >= 45)
m.addConstr(7*x1 + 6*x2 >= 24)
m.addConstr(7*x0 + 26*x3 >= 30)
m.addConstr(7*x0 + 7*x1 + 26*x3 >= 40)
m.addConstr(7*x0 + 6*x2 + 26*x3 >= 40)
m.addConstr(7*x1 + 6*x2 + 26*x3 >= 40)
m.addConstr(7*x0 + 7*x1 + 26*x3 >= 41)
m.addConstr(7*x0 + 6*x2 + 26*x3 >= 41)
m.addConstr(7*x1 + 6*x2 + 26*x3 >= 41)
m.addConstr(7*x0 + 7*x1 + 26*x3 >= 31)
m.addConstr(7*x0 + 6*x2 + 26*x3 >= 31)
m.addConstr(7*x1 + 6*x2 + 26*x3 >= 31)
m.addConstr(7*x0 + 7*x1 + 6*x2 + 26*x3 >= 31)

# Additional constraints
m.addConstr(9*x0 - 2*x3 >= 0)
m.addConstr(-3*x2 + 9*x3 >= 0)

# Optimize model
m.optimize()
