
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
cantaloupes = m.addVar(name="cantaloupes", lb=0)
lemons = m.addVar(name="lemons", lb=0)
ham_sandwiches = m.addVar(name="ham_sandwiches", lb=0)
strawberries = m.addVar(name="strawberries", lb=0)

# Objective function
m.setObjective(7.05 * cantaloupes + 1.79 * lemons + 9.61 * ham_sandwiches + 3.42 * strawberries, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches + 19 * strawberries <= 435, name="r0")
m.addConstr(7 * cantaloupes + 7 * lemons + 6 * ham_sandwiches + 26 * strawberries <= 247, name="r1")

m.addConstr(29 * cantaloupes + 19 * strawberries >= 62, name="tastiness_cantaloupes_strawberries")
m.addConstr(1 * lemons + 23 * ham_sandwiches >= 62, name="tastiness_lemons_ham_sandwiches")
m.addConstr(23 * ham_sandwiches + 19 * strawberries >= 80, name="tastiness_ham_sandwiches_strawberries")
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 104, name="tastiness_lemons_ham_sandwiches_strawberries")
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 104, name="tastiness_cantaloupes_lemons_ham_sandwiches")
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 104, name="tastiness_cantaloupes_lemons_strawberries")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 104, name="tastiness_cantaloupes_ham_sandwiches_strawberries")
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 95, name="tastiness_lemons_ham_sandwiches_strawberries_95")
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 95, name="tastiness_cantaloupes_lemons_ham_sandwiches_95")
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 95, name="tastiness_cantaloupes_lemons_strawberries_95")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 95, name="tastiness_cantaloupes_ham_sandwiches_strawberries_95")
m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 57, name="tastiness_lemons_ham_sandwiches_strawberries_57")
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 57, name="tastiness_cantaloupes_lemons_ham_sandwiches_57")
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 57, name="tastiness_cantaloupes_lemons_strawberries_57")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 57, name="tastiness_cantaloupes_ham_sandwiches_strawberries_57")

m.addConstr(1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 108, name="tastiness_lemons_ham_sandwiches_strawberries_108")
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches >= 108, name="tastiness_cantaloupes_lemons_ham_sandwiches_108")
m.addConstr(29 * cantaloupes + 1 * lemons + 19 * strawberries >= 108, name="tastiness_cantaloupes_lemons_strawberries_108")
m.addConstr(29 * cantaloupes + 23 * ham_sandwiches + 19 * strawberries >= 108, name="tastiness_cantaloupes_ham_sandwiches_strawberries_108")
m.addConstr(29 * cantaloupes + 1 * lemons + 23 * ham_sandwiches + 19 * strawberries >= 108, name="tastiness_all_108")

m.addConstr(7 * cantaloupes + 6 * ham_sandwiches >= 45, name="protein_cantaloupes_ham_sandwiches")
m.addConstr(7 * lemons + 6 * ham_sandwiches >= 24, name="protein_lemons_ham_sandwiches")
m.addConstr(7 * cantaloupes + 26 * strawberries >= 30, name="protein_cantaloupes_strawberries")
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 40, name="protein_cantaloupes_lemons_strawberries")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 40, name="protein_cantaloupes_ham_sandwiches_strawberries")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 40, name="protein_lemons_ham_sandwiches_strawberries")
m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 41, name="protein_cantaloupes_lemons_strawberries_41")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 41, name="protein_cantaloupes_ham_sandwiches_strawberries_41")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 41, name="protein_lemons_ham_sandwiches_strawberries_41")

m.addConstr(7 * cantaloupes + 7 * lemons + 26 * strawberries >= 31, name="protein_cantaloupes_lemons_strawberries_31")
m.addConstr(7 * cantaloupes + 6 * ham_sandwiches + 26 * strawberries >= 31, name="protein_cantaloupes_ham_sandwiches_strawberries_31")
m.addConstr(7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31, name="protein_lemons_ham_sandwiches_strawberries_31")
m.addConstr(7 * cantaloupes + 7 * lemons + 6 * ham_sandwiches + 26 * strawberries >= 31, name="protein_all_31")

m.addConstr(9 * cantaloupes - 2 * strawberries >= 0, name="cantaloupes_strawberries")
m.addConstr(-3 * ham_sandwiches + 9 * strawberries >= 0, name="ham_sandwiches_strawberries")

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Cantaloupes: ", cantaloupes.varValue)
    print("Lemons: ", lemons.varValue)
    print("Ham Sandwiches: ", ham_sandwiches.varValue)
    print("Strawberries: ", strawberries.varValue)
else:
    print("The model is infeasible.")
