
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Create variables
corn_cobs = m.addVar(lb=0, name="corn_cobs")
apple_pies = m.addVar(lb=0, name="apple_pies")

# Set objective function
m.setObjective(6 * corn_cobs + 4 * apple_pies, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * corn_cobs + 13 * apple_pies >= 25, "fiber_min")
m.addConstr(13 * corn_cobs + 12 * apple_pies >= 32, "calcium_min")
m.addConstr(-5 * corn_cobs + 4 * apple_pies >= 0, "corn_apple_ratio")
m.addConstr(1 * corn_cobs + 13 * apple_pies <= 92, "fiber_max") # Combined redundant constraints
m.addConstr(13 * corn_cobs + 12 * apple_pies <= 41, "calcium_max") # Combined redundant constraints


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Corn cobs: {corn_cobs.x}")
    print(f"Apple pies: {apple_pies.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

