
from gurobipy import *

# Create a model
m = Model("Optimization_Model")

# Define variables
corn_cobs = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="corn_cobs")
apple_pies = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="apple_pies")

# Objective function: Maximize 6*corn_cobs + 4*apple_pies
m.setObjective(6*corn_cobs + 4*apple_pies, GRB.MAXIMIZE)

# Constraints
# 1. Fiber constraint
m.addConstr(corn_cobs + 13*apple_pies >= 25, name="fiber_lower_bound")
m.addConstr(corn_cobs + 13*apple_pies <= 92, name="fiber_upper_bound")

# 2. Calcium constraint
m.addConstr(13*corn_cobs + 12*apple_pies >= 32, name="calcium_lower_bound")
m.addConstr(13*corn_cobs + 12*apple_pies <= 41, name="calcium_upper_bound")

# 3. Additional constraint
m.addConstr(-5*corn_cobs + 4*apple_pies >= 0, name="additional_constraint")

# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Corn cobs: {corn_cobs.x}")
    print(f"Apple pies: {apple_pies.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
