
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    corn_cobs = model.addVar(lb=0, name="corn_cobs", vtype=gurobi.GRB.CONTINUOUS)
    apple_pies = model.addVar(lb=0, name="apple_pies", vtype=gurobi.GRB.CONTINUOUS)

    # Objective function: Maximize 6 * corn_cobs + 4 * apple_pies
    model.setObjective(6 * corn_cobs + 4 * apple_pies, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Fiber constraint: 1 * corn_cobs + 13 * apple_pies >= 25
    model.addConstr(1 * corn_cobs + 13 * apple_pies >= 25, name="fiber_min")
    
    # Calcium constraint: 13 * corn_cobs + 12 * apple_pies >= 32
    model.addConstr(13 * corn_cobs + 12 * apple_pies >= 32, name="calcium_min")
    
    # Linear constraint: -5 * corn_cobs + 4 * apple_pies >= 0
    model.addConstr(-5 * corn_cobs + 4 * apple_pies >= 0, name="linear_constraint")
    
    # Fiber upper bound: 1 * corn_cobs + 13 * apple_pies <= 92
    model.addConstr(1 * corn_cobs + 13 * apple_pies <= 92, name="fiber_max")
    
    # Calcium upper bound: 13 * corn_cobs + 12 * apple_pies <= 41
    model.addConstr(13 * corn_cobs + 12 * apple_pies <= 41, name="calcium_max")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Corn Cobs: {corn_cobs.varValue}")
        print(f"Apple Pies: {apple_pies.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
