
from gurobipy import Model, GRB

# Create a new model
model = Model("Supplement_Optimization")

# Create variables
calcium = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="calcium")
zinc = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="zinc")
vitamin_b1 = model.addVar(lb=0, vtype=GRB.CONTINUOUS, name="vitamin_b1")
vitamin_b5 = model.addVar(lb=0, vtype=GRB.INTEGER, name="vitamin_b5")


# Set objective function
model.setObjective(5.08 * calcium * zinc + 6.35 * zinc * zinc + 6.26 * zinc * vitamin_b1 + 6.59 * zinc * vitamin_b5 + 3.56 * vitamin_b1 * vitamin_b1, GRB.MAXIMIZE)

# Add constraints
model.addConstr(6.16 * vitamin_b1 + 0.26 * vitamin_b5 >= 81, "c1")
model.addConstr(3.53 * calcium * calcium + 10.75 * zinc * zinc >= 58, "c2")
model.addConstr(15.02 * calcium + 13.63 * zinc + 3.1 * vitamin_b5 >= 40, "c3")
model.addConstr(15.02 * calcium + 13.63 * zinc + 8.91 * vitamin_b1 >= 40, "c4")
model.addConstr(13.63 * zinc + 8.91 * vitamin_b1 + 3.1 * vitamin_b5 >= 40, "c5")
model.addConstr(15.02 * calcium * calcium + 13.63 * zinc * zinc + 3.1 * vitamin_b5 * vitamin_b5 >= 24, "c6")
model.addConstr(15.02 * calcium + 13.63 * zinc + 8.91 * vitamin_b1 >= 24, "c7")
model.addConstr(13.63 * zinc * zinc + 8.91 * vitamin_b1 * vitamin_b1 + 3.1 * vitamin_b5 * vitamin_b5 >= 24, "c8")
model.addConstr(15.02 * calcium + 13.63 * zinc + 3.1 * vitamin_b5 >= 33, "c9")
model.addConstr(15.02 * calcium + 13.63 * zinc + 8.91 * vitamin_b1 >= 33, "c10")
model.addConstr(13.63 * zinc + 8.91 * vitamin_b1 + 3.1 * vitamin_b5 >= 33, "c11")
model.addConstr(3.53 * calcium * calcium + 10.75 * zinc * zinc <= 186, "c12")
model.addConstr(10.75 * zinc + 0.26 * vitamin_b5 <= 136, "c13")
model.addConstr(3.53 * calcium + 6.16 * vitamin_b1 <= 190, "c14")
model.addConstr(3.53 * calcium * calcium + 6.16 * vitamin_b1 * vitamin_b1 + 0.26 * vitamin_b5 * vitamin_b5 <= 370, "c15")
model.addConstr(3.53 * calcium + 10.75 * zinc + 6.16 * vitamin_b1 + 0.26 * vitamin_b5 <= 370, "c16")  # Corrected constraint
model.addConstr(15.02 * calcium * calcium + 3.1 * vitamin_b5 * vitamin_b5 <= 159, "c17")
model.addConstr(8.91 * vitamin_b1 + 3.1 * vitamin_b5 <= 142, "c18")
model.addConstr(15.02 * calcium * calcium + 8.91 * vitamin_b1 * vitamin_b1 <= 50, "c19")
model.addConstr(15.02 * calcium * calcium + 13.63 * zinc * zinc <= 147, "c20")
model.addConstr(15.02 * calcium * calcium + 13.63 * zinc * zinc + 3.1 * vitamin_b5 * vitamin_b5 <= 120, "c21")
model.addConstr(15.02 * calcium * calcium + 13.63 * zinc * zinc + 8.91 * vitamin_b1 * vitamin_b1 <= 102, "c22")
model.addConstr(15.02 * calcium * calcium + 8.91 * vitamin_b1 * vitamin_b1 + 3.1 * vitamin_b5 * vitamin_b5 <= 78, "c23")
model.addConstr(15.02 * calcium + 13.63 * zinc + 8.91 * vitamin_b1 + 3.1 * vitamin_b5 <= 78, "c24")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('calcium:', calcium.x)
    print('zinc:', zinc.x)
    print('vitamin_b1:', vitamin_b1.x)
    print('vitamin_b5:', vitamin_b5.x)
elif model.status == GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", model.status)

