
import gurobi

def optimize_problem():
    model = gurobi.Model()

    # Define variables
    x0 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="calcium")
    x1 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="zinc")
    x2 = model.addVar(lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY, name="vitamin_B1")
    x3 = model.addVar(lb=0, ub=gurobi.GRB.INFINITY, integrality=1, name="vitamin_B5")  # Integer constraint

    # Objective function
    model.setObjective(5.08*x0*x1 + 6.35*x1**2 + 6.26*x1*x2 + 6.59*x1*x3 + 3.56*x2**2, gurobi.GRB.MAXIMIZE)

    # Constraints
    model.addConstr(3.53*x0 <= 376)
    model.addConstr(15.02*x0 <= 184)
    model.addConstr(10.75*x1 <= 376)
    model.addConstr(13.63*x1 <= 184)
    model.addConstr(6.16*x2 <= 376)
    model.addConstr(8.91*x2 <= 184)
    model.addConstr(0.26*x3 <= 376)
    model.addConstr(3.1*x3 <= 184)

    model.addConstr(6.16*x2 + 0.26*x3 >= 81)
    model.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 >= 58)
    model.addConstr(15.02*x0 + 13.63*x1 + 3.1*x3 >= 40)
    model.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 40)
    model.addConstr(13.63*x1 + 8.91*x2 + 3.1*x3 >= 40)
    model.addConstr(15.02**2*x0**2 + 13.63**2*x1**2 + 3.1**2*x3**2 >= 24)
    model.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 24)
    model.addConstr(13.63**2*x1**2 + 8.91**2*x2**2 + 3.1**2*x3**2 >= 24)
    model.addConstr(15.02*x0 + 13.63*x1 + 3.1*x3 >= 33)
    model.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 >= 33)
    model.addConstr(13.63*x1 + 8.91*x2 + 3.1*x3 >= 33)

    model.addConstr(3.53**2*x0**2 + 10.75**2*x1**2 <= 186)
    model.addConstr(10.75*x1 + 0.26*x3 <= 136)
    model.addConstr(3.53*x0 + 6.16*x2 <= 190)
    model.addConstr(3.53**2*x0**2 + 6.16**2*x2**2 + 0.26**2*x3**2 <= 370)
    model.addConstr(3.53*x0 + 10.75*x1 + 6.16*x2 + 0.26*x3 <= 370)
    model.addConstr(15.02**2*x0**2 + 3.1**2*x3**2 <= 159)
    model.addConstr(8.91*x2 + 3.1*x3 <= 142)
    model.addConstr(15.02**2*x0**2 + 8.91**2*x2**2 <= 50)
    model.addConstr(15.02**2*x0**2 + 13.63**2*x1**2 <= 147)
    model.addConstr(15.02**2*x0**2 + 13.63**2*x1**2 + 3.1**2*x3**2 <= 120)
    model.addConstr(15.02**2*x0**2 + 13.63**2*x1**2 + 8.91**2*x2**2 <= 102)
    model.addConstr(15.02**2*x0**2 + 8.91**2*x2**2 + 3.1**2*x3**2 <= 78)
    model.addConstr(15.02*x0 + 13.63*x1 + 8.91*x2 + 3.1*x3 <= 78)

    model.optimize()

    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Calcium: {x0.varValue}")
        print(f"Zinc: {x1.varValue}")
        print(f"Vitamin B1: {x2.varValue}")
        print(f"Vitamin B5: {x3.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("No optimal solution found.")

optimize_problem()
