
import gurobipy as gp

# Create a new model
m = gp.Model("food_optimization")

# Create variables
steaks = m.addVar(name="steaks", lb=0)
pizza = m.addVar(name="pizza", lb=0)
chicken = m.addVar(name="chicken", lb=0)
corn = m.addVar(name="corn", lb=0)

# Set objective function
m.setObjective(9 * steaks + 6 * pizza + 1 * chicken + 3 * corn, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(2.73 * steaks + 6.21 * pizza + 8.01 * chicken + 6.38 * corn <= 178, "iron_upper_bound") # Total iron limit
m.addConstr(2.53 * steaks + 1.96 * pizza + 0.64 * chicken + 2.58 * corn <= 220, "sourness_upper_bound") # Total sourness limit

m.addConstr(8.01 * chicken + 6.38 * corn >= 16, "iron_chicken_corn")
m.addConstr(2.73 * steaks + 8.01 * chicken >= 28, "iron_steaks_chicken")
m.addConstr(2.73 * steaks + 6.21 * pizza >= 14, "iron_steaks_pizza")
m.addConstr(6.21 * pizza + 8.01 * chicken >= 26, "iron_pizza_chicken")
m.addConstr(2.73 * steaks + 6.38 * corn >= 29, "iron_steaks_corn")
m.addConstr(2.73 * steaks + 6.21 * pizza + 8.01 * chicken + 6.38 * corn >= 29, "iron_total")

m.addConstr(2.53 * steaks + 2.58 * corn >= 32, "sourness_steaks_corn")
m.addConstr(0.64 * chicken + 2.58 * corn >= 21, "sourness_chicken_corn")
m.addConstr(2.53 * steaks + 1.96 * pizza >= 25, "sourness_steaks_pizza")
m.addConstr(1.96 * pizza + 2.58 * corn >= 23, "sourness_pizza_corn")
m.addConstr(1.96 * pizza + 0.64 * chicken >= 25, "sourness_pizza_chicken")
m.addConstr(2.53 * steaks + 1.96 * pizza + 0.64 * chicken + 2.58 * corn >= 25, "sourness_total")

m.addConstr(2 * steaks - 7 * corn >= 0, "steaks_corn_relation")
m.addConstr(2.73 * steaks + 6.21 * pizza <= 139, "iron_steaks_pizza_upper")
m.addConstr(6.21 * pizza + 6.38 * corn <= 49, "iron_pizza_corn_upper")
m.addConstr(2.53 * steaks + 1.96 * pizza <= 107, "sourness_steaks_pizza_upper")
m.addConstr(0.64 * chicken + 2.58 * corn <= 91, "sourness_chicken_corn_upper")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)
