
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
steaks = m.addVar(name="steaks", lb=0)
slices_of_pizza = m.addVar(name="slices_of_pizza", lb=0)
chicken_drumsticks = m.addVar(name="chicken_drumsticks", lb=0)
corn_cobs = m.addVar(name="corn_cobs", lb=0)

# Objective function
m.setObjective(9 * steaks + 6 * slices_of_pizza + chicken_drumsticks + 3 * corn_cobs, gp.GRB.MINIMIZE)

# Constraints
m.addConstr(2.73 * steaks + 6.21 * slices_of_pizza + 8.01 * chicken_drumsticks + 6.38 * corn_cobs <= 178)
m.addConstr(2.53 * steaks + 1.96 * slices_of_pizza + 0.64 * chicken_drumsticks + 2.58 * corn_cobs <= 220)
m.addConstr(8.01 * chicken_drumsticks + 6.38 * corn_cobs >= 16)
m.addConstr(2.73 * steaks + 8.01 * chicken_drumsticks >= 28)
m.addConstr(2.73 * steaks + 6.21 * slices_of_pizza >= 14)
m.addConstr(6.21 * slices_of_pizza + 8.01 * chicken_drumsticks >= 26)
m.addConstr(2.73 * steaks + 6.38 * corn_cobs >= 29)
m.addConstr(2.73 * steaks + 6.21 * slices_of_pizza + 8.01 * chicken_drumsticks + 6.38 * corn_cobs >= 29)
m.addConstr(2.53 * steaks + 2.58 * corn_cobs >= 32)
m.addConstr(0.64 * chicken_drumsticks + 2.58 * corn_cobs >= 21)
m.addConstr(2.53 * steaks + 1.96 * slices_of_pizza >= 25)
m.addConstr(1.96 * slices_of_pizza + 2.58 * corn_cobs >= 23)
m.addConstr(1.96 * slices_of_pizza + 0.64 * chicken_drumsticks >= 25)
m.addConstr(2.53 * steaks + 1.96 * slices_of_pizza + 0.64 * chicken_drumsticks + 2.58 * corn_cobs >= 25)
m.addConstr(2 * steaks - 7 * corn_cobs >= 0)
m.addConstr(2.73 * steaks + 6.21 * slices_of_pizza <= 139)
m.addConstr(6.21 * slices_of_pizza + 6.38 * corn_cobs <= 49)
m.addConstr(2.53 * steaks + 1.96 * slices_of_pizza <= 107)
m.addConstr(0.64 * chicken_drumsticks + 2.58 * corn_cobs <= 91)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Objective: ", m.objVal)
    print("Steaks: ", steaks.varValue)
    print("Slices of Pizza: ", slices_of_pizza.varValue)
    print("Chicken Drumsticks: ", chicken_drumsticks.varValue)
    print("Corn Cobs: ", corn_cobs.varValue)
else:
    print("The model is infeasible")
