
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
fat = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="fat_grams")
b12 = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="b12_mg")

# Set objective function
m.setObjective(5.14 * fat + 5.3 * b12, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * fat + 17 * b12 >= 16, "min_cognitive_performance")
m.addConstr(7 * fat + 17 * b12 >= 48, "min_cardiovascular_support")
m.addConstr(-4 * fat + 10 * b12 >= 0, "fat_b12_ratio")
m.addConstr(17 * fat + 17 * b12 <= 38, "max_cognitive_performance")  # Combined constraint
m.addConstr(7 * fat + 17 * b12 <= 104, "max_cardiovascular_support") # Combined constraint


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal objective value: {m.objVal}")
    print(f"Grams of fat: {fat.x}")
    print(f"Milligrams of Vitamin B12: {b12.x}")
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print(f"Optimization ended with status: {m.status}")

