
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define the decision variables
grams_of_fat = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_fat")
milligrams_of_vitamin_B12 = m.addVar(lb=0, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="milligrams_of_vitamin_B12")

# Define the objective function
m.setObjective(5.14 * grams_of_fat + 5.3 * milligrams_of_vitamin_B12, GRB.MAXIMIZE)

# Add constraints
m.addConstr(17 * grams_of_fat + 17 * milligrams_of_vitamin_B12 >= 16, name="min_cognitive_performance")
m.addConstr(7 * grams_of_fat + 17 * milligrams_of_vitamin_B12 >= 48, name="min_cardiovascular_support")
m.addConstr(-4 * grams_of_fat + 10 * milligrams_of_vitamin_B12 >= 0, name="linear_constraint")
m.addConstr(17 * grams_of_fat + 17 * milligrams_of_vitamin_B12 <= 38, name="max_cognitive_performance")
m.addConstr(7 * grams_of_fat + 17 * milligrams_of_vitamin_B12 <= 104, name="max_cardiovascular_support")

# Optimize the model
m.optimize()

# Print the results
for v in m.getVars():
    print(f"{v.varName}: {v.x}")
print(f"Objective: {m.objVal}")
