
import gurobi

def optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    grams_of_fat = model.addVar(name="grams_of_fat", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)
    milligrams_of_vitamin_B12 = model.addVar(name="milligrams_of_vitamin_B12", lb=-gurobi.GRB.INFINITY, ub=gurobi.GRB.INFINITY)

    # Objective function
    model.setObjective(5.14 * grams_of_fat + 5.3 * milligrams_of_vitamin_B12, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Cognitive performance index of grams of fat
    model.addConstraint(grams_of_fat * 17 <= 52)

    # Cardiovascular support index for grams of fat
    model.addConstraint(grams_of_fat * 7 <= 176)

    # Cognitive performance index of milligrams of vitamin B12
    model.addConstraint(milligrams_of_vitamin_B12 * 17 <= 52)

    # Cardiovascular support index of milligrams of vitamin B12
    model.addConstraint(milligrams_of_vitamin_B12 * 17 <= 176)

    # Total combined cognitive performance index >= 16
    model.addConstraint(17 * grams_of_fat + 17 * milligrams_of_vitamin_B12 >= 16)

    # Total combined cardiovascular support index >= 48
    model.addConstraint(7 * grams_of_fat + 17 * milligrams_of_vitamin_B12 >= 48)

    # Linear constraint
    model.addConstraint(-4 * grams_of_fat + 10 * milligrams_of_vitamin_B12 >= 0)

    # Total combined cognitive performance index <= 38
    model.addConstraint(17 * grams_of_fat + 17 * milligrams_of_vitamin_B12 <= 38)

    # Total combined cardiovascular support index <= 104
    model.addConstraint(7 * grams_of_fat + 17 * milligrams_of_vitamin_B12 <= 104)

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.Status.OPTIMAL:
        print("Objective: ", model.objVal)
        print("Grams of fat: ", grams_of_fat.varValue)
        print("Milligrams of vitamin B12: ", milligrams_of_vitamin_B12.varValue)
    else:
        print("The model is infeasible")

optimization_problem()
