
import gurobipy as gp

# Create a new model
m = gp.Model("PlantOptimization")

# Create variables
bean_stalks = m.addVar(vtype=gp.GRB.INTEGER, name="bean_stalks")
strawberry_bushes = m.addVar(vtype=gp.GRB.INTEGER, name="strawberry_bushes")
agave = m.addVar(vtype=gp.GRB.INTEGER, name="agave")
tulips = m.addVar(vtype=gp.GRB.INTEGER, name="tulips")

# Set objective function
m.setObjective(1 * bean_stalks + 2 * strawberry_bushes + 7 * agave + 2 * tulips, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(6 * bean_stalks + 6 * strawberry_bushes + 2 * agave + 21 * tulips <= 327, "dollar_cost") # Total cost
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 3 * agave + 16 * tulips <= 234, "growth_speed") # Total growth speed
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 11 * agave + 21 * tulips <= 233, "resilience_index") # Total resilience
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 8 * agave + 23 * tulips <= 162, "beauty_rating") # Total beauty rating

m.addConstr(6 * strawberry_bushes + 2 * agave >= 80, "strawberry_agave_cost_min")
m.addConstr(6 * strawberry_bushes + 21 * tulips >= 53, "strawberry_tulips_cost_min")
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes >= 31, "bean_strawberry_growth_min")
m.addConstr(1 * strawberry_bushes + 3 * agave + 16 * tulips >= 58, "strawberry_agave_tulips_growth_min")
m.addConstr(13 * bean_stalks + 11 * agave + 21 * tulips >= 51, "bean_agave_tulips_resilience_min") # Corrected and tightened constraint
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 21 * tulips >= 51, "bean_strawberry_tulips_resilience_min") # Corrected and tightened constraint
m.addConstr(10 * bean_stalks + 8 * agave + 23 * tulips >= 27, "bean_agave_tulips_beauty_min") # Corrected constraint
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 23 * tulips >= 27, "bean_strawberry_tulips_beauty_min") # Corrected constraint

m.addConstr(2 * agave + 21 * tulips <= 175, "agave_tulips_cost_max")
m.addConstr(6 * bean_stalks + 2 * agave <= 299, "bean_agave_cost_max")
m.addConstr(6 * strawberry_bushes + 2 * agave <= 142, "strawberry_agave_cost_max")
m.addConstr(6 * bean_stalks + 6 * strawberry_bushes + 2 * agave + 21 * tulips <= 142, "total_cost_max") # Corrected constraint
m.addConstr(1 * strawberry_bushes + 16 * tulips <= 173, "strawberry_tulips_growth_max")
m.addConstr(15 * bean_stalks + 16 * tulips <= 84, "bean_tulips_growth_max")
m.addConstr(15 * bean_stalks + 3 * agave <= 72, "bean_agave_growth_max")
m.addConstr(3 * agave + 16 * tulips <= 186, "agave_tulips_growth_max")
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 3 * agave <= 109, "bean_strawberry_agave_growth_max")
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 16 * tulips <= 196, "bean_strawberry_tulips_growth_max")
m.addConstr(15 * bean_stalks + 1 * strawberry_bushes + 3 * agave + 16 * tulips <= 196, "total_growth_max")
m.addConstr(13 * bean_stalks + 21 * tulips <= 162, "bean_tulips_resilience_max")
m.addConstr(17 * strawberry_bushes + 11 * agave <= 62, "strawberry_agave_resilience_max")
m.addConstr(13 * bean_stalks + 11 * agave <= 150, "bean_agave_resilience_max")
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 11 * agave <= 160, "bean_strawberry_agave_resilience_max")
m.addConstr(13 * bean_stalks + 17 * strawberry_bushes + 11 * agave + 21 * tulips <= 160, "total_resilience_max")
m.addConstr(4 * strawberry_bushes + 23 * tulips <= 136, "strawberry_tulips_beauty_max")
m.addConstr(10 * bean_stalks + 8 * agave <= 126, "bean_agave_beauty_max")
m.addConstr(10 * bean_stalks + 23 * tulips <= 52, "bean_tulips_beauty_max")
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 23 * tulips <= 150, "bean_strawberry_tulips_beauty_max")
m.addConstr(10 * bean_stalks + 8 * agave + 23 * tulips <= 88, "bean_agave_tulips_beauty_max")
m.addConstr(10 * bean_stalks + 4 * strawberry_bushes + 8 * agave + 23 * tulips <= 88, "total_beauty_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
else:
    print("Infeasible")

