
import gurobipy as gp

# Create a new model
m = gp.Model("optimize_work_hours")

# Create variables
peggy_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peggy_hours")
laura_hours = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="laura_hours")

# Set objective function
m.setObjective(9 * peggy_hours + 6 * laura_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(14.74 * peggy_hours + 7.16 * laura_hours >= 35, "dollar_cost_min")
m.addConstr(11.02 * peggy_hours + 19.32 * laura_hours >= 51, "quality_rating_min")
m.addConstr(-6 * peggy_hours + 9 * laura_hours >= 0, "peggy_laura_ratio")
m.addConstr(14.74 * peggy_hours + 7.16 * laura_hours <= 98, "dollar_cost_max")
m.addConstr(11.02 * peggy_hours + 19.32 * laura_hours <= 119, "quality_rating_max")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print(f"Optimal solution found:")
    print(f"  Peggy's hours: {peggy_hours.x}")
    print(f"  Laura's hours: {laura_hours.x}")
    print(f"  Objective value: {m.objVal}")
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible.")
else:
    print(f"Optimization terminated with status {m.status}")

