
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define decision variables
hours_worked_by_Peggy = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")
hours_worked_by_Laura = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="hours_worked_by_Laura")

# Objective function: Maximize 9 * hours_worked_by_Peggy + 6 * hours_worked_by_Laura
m.setObjective(9 * hours_worked_by_Peggy + 6 * hours_worked_by_Laura, GRB.MAXIMIZE)

# Constraints
# 1. Total combined dollar cost per hour >= 35
m.addConstr(14.74 * hours_worked_by_Peggy + 7.16 * hours_worked_by_Laura >= 35, name="dollar_cost_lower_bound")

# 2. Total combined work quality rating >= 51
m.addConstr(11.02 * hours_worked_by_Peggy + 19.32 * hours_worked_by_Laura >= 51, name="work_quality_lower_bound")

# 3. -6 * hours_worked_by_Peggy + 9 * hours_worked_by_Laura >= 0
m.addConstr(-6 * hours_worked_by_Peggy + 9 * hours_worked_by_Laura >= 0, name="linear_constraint")

# 4. Total combined dollar cost per hour <= 98
m.addConstr(14.74 * hours_worked_by_Peggy + 7.16 * hours_worked_by_Laura <= 98, name="dollar_cost_upper_bound")

# 5. Total combined work quality rating <= 119
m.addConstr(11.02 * hours_worked_by_Peggy + 19.32 * hours_worked_by_Laura <= 119, name="work_quality_upper_bound")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print("Hours worked by Peggy:", hours_worked_by_Peggy.x)
    print("Hours worked by Laura:", hours_worked_by_Laura.x)
    print("Objective function value:", m.objVal)
else:
    print("No optimal solution found. Status:", m.status)
