
import gurobipy as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="hours_worked_by_Peggy", lb=0)  # Assuming hours cannot be negative
x1 = m.addVar(name="hours_worked_by_Laura", lb=0)  # Assuming hours cannot be negative

# Define coefficients
c0 = 9
c1 = 6

# Objective function: Maximize c0*x0 + c1*x1
m.setObjective(c0*x0 + c1*x1, gp.GRB.MAXIMIZE)

# Constraints
# 1. Total combined dollar cost per hour >= 35
m.addConstr(14.74*x0 + 7.16*x1 >= 35, name="dollar_cost_constraint")

# 2. Total combined work quality rating >= 51
m.addConstr(11.02*x0 + 19.32*x1 >= 51, name="work_quality_constraint")

# 3. -6*x0 + 9*x1 >= 0
m.addConstr(-6*x0 + 9*x1 >= 0, name="hourly_balance_constraint")

# 4. & 5. Total combined dollar cost per hour <= 98 and work quality rating <= 119
m.addConstr(14.74*x0 + 7.16*x1 <= 98, name="dollar_cost_upper_bound")
m.addConstr(11.02*x0 + 19.32*x1 <= 119, name="work_quality_upper_bound")

# Solve the model
m.optimize()

# Print solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal Solution:")
    print(f"Hours worked by Peggy: {x0.varValue}")
    print(f"Hours worked by Laura: {x1.varValue}")
    print(f"Objective: {m.objVal}")
else:
    print("The model is infeasible.")
