
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Labor Cost")

# Create variables
laura_hours = model.addVar(vtype=GRB.INTEGER, name="laura_hours")  # Integer constraint for Laura
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
model.setObjective(9 * laura_hours + 6 * peggy_hours, GRB.MINIMIZE)

# Add constraints
model.addConstr(14.34 * laura_hours + 1.9 * peggy_hours >= 47, "productivity_min")
model.addConstr(14.34 * laura_hours + 1.9 * peggy_hours <= 73, "productivity_max")

model.addConstr(6.17 * laura_hours + 4.28 * peggy_hours >= 34, "quality_min")
model.addConstr(6.17 * laura_hours + 4.28 * peggy_hours <= 100, "quality_max")

model.addConstr(5.43 * laura_hours + 6.99 * peggy_hours >= 44, "cost_min")
model.addConstr(5.43 * laura_hours + 6.99 * peggy_hours <= 82, "cost_max")

model.addConstr(2 * laura_hours - peggy_hours >= 0, "hours_relation")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Optimal objective value:', model.objVal)
    print('Laura hours:', laura_hours.x)
    print('Peggy hours:', peggy_hours.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")

