
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define decision variables
hours_worked_by_Laura = m.addVar(vtype=GRB.INTEGER, name="hours_worked_by_Laura")
hours_worked_by_Peggy = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Objective function: Minimize 9*Laura + 6*Peggy
m.setObjective(9 * hours_worked_by_Laura + 6 * hours_worked_by_Peggy, GRB.MINIMIZE)

# Constraints
# Combined productivity rating constraint (minimum)
m.addConstr(14.34 * hours_worked_by_Laura + 1.9 * hours_worked_by_Peggy >= 47, name="combined_productivity_min")

# Combined work quality rating constraint (minimum)
m.addConstr(6.17 * hours_worked_by_Laura + 4.28 * hours_worked_by_Peggy >= 34, name="combined_work_quality_min")

# Combined dollar cost per hour constraint (minimum)
m.addConstr(5.43 * hours_worked_by_Laura + 6.99 * hours_worked_by_Peggy >= 44, name="combined_dollar_cost_min")

# Specific linear constraint
m.addConstr(2 * hours_worked_by_Laura - 1 * hours_worked_by_Peggy >= 0, name="linear_constraint")

# Upper bounds on combined productivity, work quality, and dollar cost
m.addConstr(14.34 * hours_worked_by_Laura + 1.9 * hours_worked_by_Peggy <= 73, name="combined_productivity_max")
m.addConstr(6.17 * hours_worked_by_Laura + 4.28 * hours_worked_by_Peggy <= 100, name="combined_work_quality_max")
m.addConstr(5.43 * hours_worked_by_Laura + 6.99 * hours_worked_by_Peggy <= 82, name="combined_dollar_cost_max")

# Optimize the model
m.optimize()

# Print results if an optimal solution is found
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Laura: {hours_worked_by_Laura.x}")
    print(f"Hours worked by Peggy: {hours_worked_by_Peggy.x}")
else:
    print("No optimal solution found.")
