
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    x_L = model.addVar(name="hours_worked_by_Laura", vtype=gurobi.GRB.INTEGER)
    x_P = model.addVar(name="hours_worked_by_Peggy")

    # Objective function: Minimize 9 * x_L + 6 * x_P
    model.setObjective(9 * x_L + 6 * x_P, gurobi.GRB.MINIMIZE)

    # Constraints
    model.addConstr(14.34 * x_L + 1.9 * x_P >= 47, name="productivity_rating_constraint")
    model.addConstr(6.17 * x_L + 4.28 * x_P >= 34, name="work_quality_rating_constraint")
    model.addConstr(5.43 * x_L + 6.99 * x_P >= 44, name="dollar_cost_per_hour_constraint")
    model.addConstr(2 * x_L - x_P >= 0, name="hours_worked_constraint")
    model.addConstr(14.34 * x_L + 1.9 * x_P <= 73, name="productivity_rating_upper_bound")
    model.addConstr(6.17 * x_L + 4.28 * x_P <= 100, name="work_quality_rating_upper_bound")
    model.addConstr(5.43 * x_L + 6.99 * x_P <= 82, name="dollar_cost_per_hour_upper_bound")

    # Optimize
    model.optimize()

    # Print solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Laura: {x_L.varValue}")
        print(f"Hours worked by Peggy: {x_P.varValue}")
        print(f"Objective function value: {model.objVal}")
    else:
        print("No optimal solution found.")

solve_optimization_problem()
