
from gurobipy import Model, GRB

# Create a new model
model = Model("optimization_problem")

# Create variables
potassium = model.addVar(vtype=GRB.INTEGER, name="potassium")
carbohydrates = model.addVar(vtype=GRB.CONTINUOUS, name="carbohydrates")
fiber = model.addVar(vtype=GRB.INTEGER, name="fiber")
vitamin_d = model.addVar(vtype=GRB.INTEGER, name="vitamin_d")

# Set objective function
model.setObjective(9.98*potassium**2 + 7.69*potassium*carbohydrates + 5.3*potassium*vitamin_d + 3.94*carbohydrates*fiber + 4.62*fiber**2 + 2.16*vitamin_d**2 + 4.23*carbohydrates + 7.64*fiber, GRB.MAXIMIZE)

# Add constraints based on resource attributes
resource_data = {'r0': {'description': 'cognitive performance index', 'upper_bound': 132, 'x0': 10, 'x1': 4, 'x2': 10, 'x3': 2}, 'r1': {'description': 'energy stability index', 'upper_bound': 142, 'x0': 8, 'x1': 3, 'x2': 4, 'x3': 3}, 'r2': {'description': 'kidney support index', 'upper_bound': 47, 'x0': 10, 'x1': 14, 'x2': 6, 'x3': 1}, 'r3': {'description': 'cardiovascular support index', 'upper_bound': 124, 'x0': 14, 'x1': 8, 'x2': 10, 'x3': 12}}

for resource, data in resource_data.items():
    model.addConstr(data['x0']*potassium + data['x1']*carbohydrates + data['x2']*fiber + data['x3']*vitamin_d <= data['upper_bound'], name=f"{data['description']}_constraint")


# Add additional constraints as provided in the prompt
model.addConstr(4*carbohydrates + 10*fiber >= 12)
model.addConstr(10*potassium + 4*carbohydrates >= 25)
model.addConstr(3*carbohydrates + 4*fiber >= 21)
model.addConstr(3*carbohydrates + 3*vitamin_d >= 17)
model.addConstr(8*potassium + 4*fiber >= 32)
model.addConstr(8*potassium + 3*carbohydrates + 4*fiber >= 28)
model.addConstr(10*potassium + 6*fiber >= 11)
model.addConstr(10*potassium**2 + 14*carbohydrates**2 >= 10)
model.addConstr(6*fiber + 1*vitamin_d >= 11)
model.addConstr(14*carbohydrates + 1*vitamin_d >= 11)
model.addConstr(14*potassium**2 + 12*vitamin_d**2 >= 14)
model.addConstr(10*fiber + 12*vitamin_d >= 20)
model.addConstr(8*carbohydrates + 10*fiber >= 25)
model.addConstr(14*potassium**2 + 8*carbohydrates**2 >= 31)
model.addConstr(4*carbohydrates**2 + 10*fiber**2 <= 102)
model.addConstr(10*fiber + 2*vitamin_d <= 49)
model.addConstr(10*potassium**2 + 2*vitamin_d**2 <= 87)
model.addConstr(10*potassium + 10*fiber <= 120)
model.addConstr(4*carbohydrates + 2*vitamin_d <= 35)
model.addConstr(10*potassium**2 + 4*carbohydrates**2 <= 62)
model.addConstr(10*potassium**2 + 4*carbohydrates**2 + 2*vitamin_d**2 <= 110)
model.addConstr(4*carbohydrates**2 + 10*fiber**2 + 2*vitamin_d**2 <= 33)
model.addConstr(10*potassium**2 + 4*carbohydrates**2 + 10*fiber**2 <= 46)
model.addConstr(10*potassium + 4*carbohydrates + 10*fiber + 2*vitamin_d <= 46)
model.addConstr(3*carbohydrates + 4*fiber <= 38)
model.addConstr(4*fiber**2 + 3*vitamin_d**2 <= 120)
model.addConstr(3*carbohydrates + 3*vitamin_d <= 66)
model.addConstr(8*potassium + 4*fiber <= 106)
model.addConstr(8*potassium + 3*carbohydrates + 4*fiber + 3*vitamin_d <= 106)
model.addConstr(14*carbohydrates**2 + 1*vitamin_d**2 <= 36)
model.addConstr(10*potassium + 1*vitamin_d <= 26)
model.addConstr(14*carbohydrates + 6*fiber + 1*vitamin_d <= 26)
model.addConstr(10*potassium + 14*carbohydrates + 6*fiber + 1*vitamin_d <= 26)
model.addConstr(8*carbohydrates**2 + 10*fiber**2 <= 36)
model.addConstr(14*potassium**2 + 12*vitamin_d**2 <= 108)
model.addConstr(14*potassium + 8*carbohydrates + 10*fiber + 12*vitamin_d <= 108)


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Obj: %g' % model.objVal)
    print('potassium:', potassium.x)
    print('carbohydrates:', carbohydrates.x)
    print('fiber:', fiber.x)
    print('vitamin_d:', vitamin_d.x)
elif model.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print(f"Optimization ended with status {model.status}")
