
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
x0 = m.addVar(name="milligrams_of_potassium", vtype=gp.GRB.INTEGER)
x1 = m.addVar(name="grams_of_carbohydrates")
x2 = m.addVar(name="grams_of_fiber", vtype=gp.GRB.INTEGER)
x3 = m.addVar(name="milligrams_of_vitamin_D", vtype=gp.GRB.INTEGER)

# Objective function
m.setObjective(9.98*x0**2 + 7.69*x0*x1 + 5.3*x0*x3 + 3.94*x1*x2 + 4.62*x2**2 + 2.16*x3**2 + 4.23*x1 + 7.64*x2, gp.GRB.MAXIMIZE)

# Direct assignments, taking the first one for each as an example
m.addConstr(x0 == 10)
m.addConstr(x1 == 4)
m.addConstr(x2 == 10)
m.addConstr(x3 == 2)

# Other constraints
m.addConstr(10*x0 + 4*x1 + 10*x2 + 2*x3 <= 132)
m.addConstr(8*x0 + 3*x1 + 4*x2 + 3*x3 <= 142)
m.addConstr(10*x0 + 14*x1 + 6*x2 + x3 <= 47)
m.addConstr(14*x0 + 8*x1 + 10*x2 + 12*x3 <= 124)

m.addConstr(4*x1 + 10*x2 >= 12)
m.addConstr(10*x0 + 4*x1 >= 25)
m.addConstr(3*x1 + 4*x2 >= 21)
m.addConstr(3*x1 + 3*x3 >= 17)
m.addConstr(8*x0 + 4*x2 >= 32)

# Solve the model
m.optimize()

# Print the objective value
print("Objective: ", m.objVal)

# Print the variable values
print("x0: ", x0.varValue)
print("x1: ", x1.varValue)
print("x2: ", x2.varValue)
print("x3: ", x3.varValue)
