
from gurobipy import Model, GRB

# Create a new model
m = Model("nutrition_optimization")

# Create variables
oranges = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="oranges")
bagged_salads = m.addVar(lb=0, vtype=GRB.INTEGER, name="bagged_salads")

# Set objective function
m.setObjective(3.92 * oranges + 5.07 * bagged_salads, GRB.MAXIMIZE)

# Add constraints based on provided resources and additional constraints
m.addConstr(1 * oranges + 2 * bagged_salads >= 13, "iron_min")
m.addConstr(4 * oranges + 5 * bagged_salads >= 6, "fat_min")
m.addConstr(5 * oranges + 3 * bagged_salads >= 8, "protein_min")

m.addConstr(-1 * oranges + 10 * bagged_salads >= 0, "orange_salad_relation")

m.addConstr(1 * oranges + 2 * bagged_salads <= 22, "iron_max") # Consolidated redundant iron max constraints
m.addConstr(4 * oranges + 5 * bagged_salads <= 16, "fat_max")  # Consolidated redundant fat max constraints
m.addConstr(5 * oranges + 3 * bagged_salads <= 11, "protein_max") # Consolidated redundant protein max constraints


# Resource constraints (already incorporated in the problem description)
m.addConstr(1 * oranges + 2 * bagged_salads <= 27, "iron_resource")
m.addConstr(4 * oranges + 5 * bagged_salads <= 19, "fat_resource")
m.addConstr(5 * oranges + 3 * bagged_salads <= 18, "protein_resource")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('oranges: %g' % oranges.x)
    print('bagged_salads: %g' % bagged_salads.x)
elif m.status == GRB.INFEASIBLE:
    print('Model is infeasible')
else:
    print('Optimization ended with status %d' % m.status)

