
from gurobipy import *

# Create a new model
m = Model("Nutrition_Optimization")

# Add variables: oranges is continuous, bagged_salads is integer
oranges = m.addVar(vtype=GRB.CONTINUOUS, name="oranges")
bagged_salads = m.addVar(vtype=GRB.INTEGER, name="bagged_salads")

# Set the objective function: Maximize 3.92 * oranges + 5.07 * bagged_salads
m.setObjective(3.92 * oranges + 5.07 * bagged_salads, GRB.MAXIMIZE)

# Define constraints
# Iron constraint: 1*oranges + 2*bagged_salads >= 13 and <= 22
m.addConstr(oranges + 2 * bagged_salads >= 13, name="iron_lower_bound")
m.addConstr(oranges + 2 * bagged_salads <= 22, name="iron_upper_bound")

# Fat constraint: 4*oranges + 5*bagged_salads >= 6 and <= 16
m.addConstr(4 * oranges + 5 * bagged_salads >= 6, name="fat_lower_bound")
m.addConstr(4 * oranges + 5 * bagged_salads <= 16, name="fat_upper_bound")

# Protein constraint: 5*oranges + 3*bagged_salads >= 8 and <= 11
m.addConstr(5 * oranges + 3 * bagged_salads >= 8, name="protein_lower_bound")
m.addConstr(5 * oranges + 3 * bagged_salads <= 11, name="protein_upper_bound")

# Linear constraint: -oranges + 10*bagged_salads >= 0
m.addConstr(-oranges + 10 * bagged_salads >= 0, name="linear_constraint")

# Optimize the model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Oranges: {oranges.x}")
    print(f"Bagged Salads: {bagged_salads.x}")
else:
    print("No optimal solution found")
