
import gurobi

def solve_optimization_problem():
    # Create a new model
    model = gurobi.Model()

    # Define variables
    oranges = model.addVar(lb=0, ub=None, vtype=gurobi.GRB.CONTINUOUS, name="oranges")
    bagged_salads = model.addVar(lb=0, vtype=gurobi.GRB.INTEGER, name="bagged_salads")

    # Objective function
    model.setObjective(3.92 * oranges + 5.07 * bagged_salads, gurobi.GRB.MAXIMIZE)

    # Constraints
    # Iron content constraints
    model.addConstr(oranges + 2 * bagged_salads >= 13, name="min_iron")
    model.addConstr(oranges + 2 * bagged_salads <= 27, name="max_iron")

    # Fat content constraints
    model.addConstr(4 * oranges + 5 * bagged_salads >= 6, name="min_fat")
    model.addConstr(4 * oranges + 5 * bagged_salads <= 16, name="max_fat")

    # Protein content constraints
    model.addConstr(5 * oranges + 3 * bagged_salads >= 8, name="min_protein")
    model.addConstr(5 * oranges + 3 * bagged_salads <= 11, name="max_protein")

    # Linear constraint
    model.addConstr(-oranges + 10 * bagged_salads >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal Solution:")
        print(f"Oranges: {oranges.varValue}")
        print(f"Bagged Salads: {bagged_salads.varValue}")
        print(f"Objective: {model.objVal}")
    else:
        print("The model is infeasible.")

solve_optimization_problem()
