
import gurobipy as gp

# Create a new model
m = gp.Model("nutrition_optimization")

# Create variables
carbohydrates = m.addVar(name="carbohydrates", lb=0.0)
fat = m.addVar(name="fat", lb=0.0)
iron = m.addVar(name="iron", lb=0.0)
vitamin_b5 = m.addVar(name="vitamin_b5", lb=0.0)
protein = m.addVar(name="protein", lb=0.0)
vitamin_b9 = m.addVar(name="vitamin_b9", lb=0.0)

# Set objective function
m.setObjective(7 * carbohydrates + 3 * fat + 1 * iron + 5 * vitamin_b5 + 2 * protein + 5 * vitamin_b9, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8 * carbohydrates + 1 * fat + 6 * iron + 6 * vitamin_b5 + 8 * protein + 7 * vitamin_b9 <= 231, "r0_cardiovascular_support")
m.addConstr(4 * carbohydrates + 4 * fat + 8 * iron + 2 * vitamin_b5 + 4 * protein + 7 * vitamin_b9 <= 98, "r1_energy_stability")

m.addConstr(6 * iron + 8 * protein >= 24, "c1")
m.addConstr(8 * protein + 7 * vitamin_b9 >= 19, "c2")
m.addConstr(6 * vitamin_b5 + 8 * protein >= 26, "c3")
m.addConstr(1 * fat + 6 * iron >= 16, "c4")
m.addConstr(1 * fat + 7 * vitamin_b9 >= 24, "c5")
m.addConstr(6 * vitamin_b5 + 7 * vitamin_b9 >= 36, "c6")
m.addConstr(6 * iron + 6 * vitamin_b5 + 8 * protein >= 27, "c7")
m.addConstr(1 * fat + 6 * vitamin_b5 + 8 * protein >= 27, "c8")
m.addConstr(8 * carbohydrates + 1 * fat + 6 * iron >= 27, "c9")
m.addConstr(6 * iron + 6 * vitamin_b5 + 8 * protein >= 26, "c10")
m.addConstr(1 * fat + 6 * vitamin_b5 + 8 * protein >= 26, "c11")
m.addConstr(8 * carbohydrates + 1 * fat + 6 * iron >= 26, "c12")
m.addConstr(6 * iron + 6 * vitamin_b5 + 8 * protein >= 23, "c13")
m.addConstr(1 * fat + 6 * vitamin_b5 + 8 * protein >= 23, "c14")
m.addConstr(8 * carbohydrates + 1 * fat + 6 * iron >= 23, "c15")
m.addConstr(8 * carbohydrates + 1 * fat + 6 * iron + 6 * vitamin_b5 + 8 * protein + 7 * vitamin_b9 >= 23, "c16")

m.addConstr(4 * carbohydrates + 2 * vitamin_b5 >= 15, "c17")
m.addConstr(8 * iron + 2 * vitamin_b5 >= 13, "c18")
m.addConstr(4 * carbohydrates + 7 * vitamin_b9 >= 16, "c19")
m.addConstr(2 * vitamin_b5 + 4 * protein >= 11, "c20")
m.addConstr(4 * fat + 8 * iron >= 7, "c21")
m.addConstr(4 * carbohydrates + 4 * fat >= 12, "c22")
m.addConstr(4 * fat + 4 * protein >= 7, "c23")
m.addConstr(4 * protein + 7 * vitamin_b9 >= 10, "c24")
m.addConstr(8 * iron + 4 * protein >= 16, "c25")
m.addConstr(4 * carbohydrates + 8 * iron >= 14, "c26")
m.addConstr(4 * carbohydrates + 2 * vitamin_b5 + 7 * vitamin_b9 >= 12, "c27")
m.addConstr(4 * carbohydrates + 4 * protein + 7 * vitamin_b9 >= 12, "c28")
m.addConstr(4 * carbohydrates + 2 * vitamin_b5 + 7 * vitamin_b9 >= 15, "c29")
m.addConstr(4 * carbohydrates + 4 * protein + 7 * vitamin_b9 >= 15, "c30")
m.addConstr(4 * carbohydrates + 4 * fat + 8 * iron + 2 * vitamin_b5 + 4 * protein + 7 * vitamin_b9 >= 15, "c31")


m.addConstr(-5 * iron + 3 * vitamin_b5 >= 0, "c32")
m.addConstr(8 * fat - 6 * iron >= 0, "c33")
m.addConstr(1 * fat + 8 * protein <= 228, "c34")
m.addConstr(8 * carbohydrates + 7 * vitamin_b9 <= 178, "c35")
m.addConstr(1 * fat + 6 * iron <= 176, "c36")
m.addConstr(1 * fat + 7 * vitamin_b9 <= 133, "c37")
m.addConstr(8 * carbohydrates + 6 * iron + 8 * protein <= 59, "c38")
m.addConstr(8 * carbohydrates + 6 * vitamin_b5 + 7 * vitamin_b9 <= 165, "c39")
m.addConstr(6 * vitamin_b5 + 8 * protein + 7 * vitamin_b9 <= 163, "c40")
m.addConstr(8 * carbohydrates + 6 * iron + 6 * vitamin_b5 <= 216, "c41")
m.addConstr(1 * fat + 6 * iron + 7 * vitamin_b9 <= 180, "c42")
m.addConstr(8 * carbohydrates + 1 * fat + 7 * vitamin_b9 <= 45, "c43")
m.addConstr(1 * fat + 6 * vitamin_b5 + 7 * vitamin_b9 <= 89, "c44")
m.addConstr(1 * fat + 6 * iron + 8 * protein <= 173, "c45")
m.addConstr(6 * iron + 6 * vitamin_b5 + 7 * vitamin_b9 <= 105, "c46")

m.addConstr(4 * fat + 2 * vitamin_b5 <= 48, "c47")
m.addConstr(8 * iron + 2 * vitamin_b5 <= 72, "c48")
m.addConstr(4 * fat + 8 * iron <= 16, "c49")
m.addConstr(8 * iron + 4 * protein + 7 * vitamin_b9 <= 86, "c50")
m.addConstr(4 * carbohydrates + 4 * fat + 8 * iron <= 82, "c51")
m.addConstr(8 * iron + 2 * vitamin_b5 + 7 * vitamin_b9 <= 76, "c52")
m.addConstr(2 * vitamin_b5 + 4 * protein + 7 * vitamin_b9 <= 19, "c53")



# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status:", m.status)

