
import gurobi as gp

# Define the model
m = gp.Model("optimization_problem")

# Define the variables
x0 = m.addVar(lb=-gp.GRB.INFINITY, name="carbohydrates")  
x1 = m.addVar(lb=-gp.GRB.INFINITY, name="fat")  
x2 = m.addVar(lb=-gp.GRB.INFINITY, name="iron")  
x3 = m.addVar(lb=-gp.GRB.INFINITY, name="vitamin_B5")  
x4 = m.addVar(lb=-gp.GRB.INFINITY, name="protein")  
x5 = m.addVar(lb=-gp.GRB.INFINITY, name="vitamin_B9")  

# Define the objective function
m.setObjective(7*x0 + 3*x1 + x2 + 5*x3 + 2*x4 + 5*x5, gp.GRB.MINIMIZE)

# Add constraints
m.addConstr(8*x0 + x1 + 6*x2 + 6*x3 + 8*x4 + 7*x5 <= 231)
m.addConstr(4*x0 + 4*x1 + 8*x2 + 2*x3 + 4*x4 + 7*x5 <= 98)

m.addConstr(6*x2 + 8*x4 >= 24)
m.addConstr(8*x4 + 7*x5 >= 19)
m.addConstr(6*x3 + 8*x4 >= 26)
m.addConstr(x1 + 6*x2 >= 16)
m.addConstr(x1 + 7*x5 >= 24)
m.addConstr(6*x3 + 7*x5 >= 36)
m.addConstr(6*x2 + 6*x3 + 8*x4 >= 27)
m.addConstr(x1 + 6*x3 + 8*x4 >= 27)
m.addConstr(8*x0 + x1 + 6*x2 >= 27)
m.addConstr(6*x2 + 6*x3 + 8*x4 >= 26)
m.addConstr(x1 + 6*x3 + 8*x4 >= 26)
m.addConstr(8*x0 + x1 + 6*x2 >= 26)

m.addConstr(8*x0 + 1*x1 + 6*x2 + 6*x3 + 8*x4 + 7*x5 >= 23)
m.addConstr(8*x0 + 1*x1 + 6*x2 >= 23)

m.addConstr(-5*x2 + 3*x3 >= 0)
m.addConstr(8*x1 - 6*x2 >= 0)

m.addConstr(x1 + 8*x4 <= 228)
m.addConstr(8*x0 + 7*x5 <= 178)
m.addConstr(x1 + 6*x2 <= 176)
m.addConstr(x1 + 7*x5 <= 133)

m.addConstr(4*x0 + 2*x3 >= 15)
m.addConstr(8*x2 + 2*x3 >= 13)
m.addConstr(4*x0 + 5*x5 >= 16)
m.addConstr(2*x3 + 4*x4 >= 11)
m.addConstr(4*x1 + 8*x2 >= 7)
m.addConstr(4*x0 + 4*x1 >= 12)
m.addConstr(4*x1 + 4*x4 >= 7)
m.addConstr(4*x4 + 5*x5 >= 10)
m.addConstr(8*x2 + 4*x4 >= 16)
m.addConstr(4*x0 + 8*x2 >= 14)

# Solve the model
m.optimize()

# Print the solution
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print("Carbohydrates:", x0.varValue)
    print("Fat:", x1.varValue)
    print("Iron:", x2.varValue)
    print("Vitamin B5:", x3.varValue)
    print("Protein:", x4.varValue)
    print("Vitamin B9:", x5.varValue)
    print("Objective:", m.objVal)
else:
    print("No optimal solution found.")
