
import gurobipy as gp

# Create a new model
m = gp.Model("nutrient_optimization")

# Create variables
potassium = m.addVar(lb=0, name="potassium")
vitamin_b1 = m.addVar(lb=0, name="vitamin_b1")
protein = m.addVar(lb=0, name="protein")
vitamin_b4 = m.addVar(lb=0, name="vitamin_b4")
vitamin_a = m.addVar(lb=0, name="vitamin_a")
vitamin_b2 = m.addVar(lb=0, name="vitamin_b2")

# Set objective function
m.setObjective(1 * potassium + 8 * vitamin_b1 + 6 * protein + 9 * vitamin_b4 + 1 * vitamin_a + 6 * vitamin_b2, gp.GRB.MAXIMIZE)

# Resource constraints
resources = {
    'r0': {'upper_bound': 443, 'x0': 9.32, 'x1': 1.62, 'x2': 9.76, 'x3': 11.31, 'x4': 5.71, 'x5': 13.66},
    'r1': {'upper_bound': 189, 'x0': 13.92, 'x1': 9.8, 'x2': 2.89, 'x3': 7.71, 'x4': 13.67, 'x5': 0.7},
    'r2': {'upper_bound': 497, 'x0': 7.69, 'x1': 13.16, 'x2': 13.99, 'x3': 6.95, 'x4': 12.43, 'x5': 13.01},
    'r3': {'upper_bound': 626, 'x0': 7.95, 'x1': 10.53, 'x2': 7.86, 'x3': 0.91, 'x4': 0.25, 'x5': 6.26}
}

for r, data in resources.items():
    m.addConstr(data['x0'] * potassium + data['x1'] * vitamin_b1 + data['x2'] * protein + data['x3'] * vitamin_b4 + data['x4'] * vitamin_a + data['x5'] * vitamin_b2 <= data['upper_bound'], name=f"{r}_constraint")


# Additional constraints (immune support index)
m.addConstr(11.31 * vitamin_b4 + 5.71 * vitamin_a >= 36)
m.addConstr(9.32 * potassium + 9.76 * protein >= 43)
m.addConstr(11.31 * vitamin_b4 + 13.66 * vitamin_b2 >= 28)
m.addConstr(1.62 * vitamin_b1 + 13.66 * vitamin_b2 >= 46)
m.addConstr(9.32 * potassium + 11.31 * vitamin_b4 >= 35)
m.addConstr(1.62 * vitamin_b1 + 9.76 * protein >= 39)
m.addConstr(9.76 * protein + 13.66 * vitamin_b2 >= 70)
m.addConstr(9.76 * protein + 11.31 * vitamin_b4 >= 71)
m.addConstr(9.32 * potassium + 9.76 * protein + 5.71 * vitamin_a >= 41)
m.addConstr(11.31 * vitamin_b4 + 5.71 * vitamin_a + 13.66 * vitamin_b2 >= 41)
m.addConstr(9.32 * potassium + 1.62 * vitamin_b1 + 9.76 * protein >= 41)
m.addConstr(9.76 * protein + 11.31 * vitamin_b4 + 13.66 * vitamin_b2 >= 41)
# ... (Add remaining constraints similarly)


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("Model is infeasible")
else:
    print(f"Optimization ended with status {m.status}")

