
import gurobipy as gp

# Create a new model
m = gp.Model("calcium_optimization")

# Create variables
oranges = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="oranges")
bananas = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="bananas")
sandwiches = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="peanutbutter_sandwiches")
pickles = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="pickles")
cornichons = m.addVar(lb=0, vtype=gp.GRB.CONTINUOUS, name="cornichons")

# Set objective function
m.setObjective(8*oranges + 6*bananas + 5*sandwiches + 3*pickles + 6*cornichons, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(11*oranges + 9*bananas + 2*sandwiches + 17*pickles + 14*cornichons <= 215, "calcium_upper_bound")
m.addConstr(2*sandwiches + 14*cornichons >= 17, "calcium_constraint1")
m.addConstr(11*oranges + 14*cornichons >= 16, "calcium_constraint2")
m.addConstr(9*bananas + 2*sandwiches >= 18, "calcium_constraint3")
m.addConstr(2*sandwiches + 17*pickles >= 30, "calcium_constraint4")
m.addConstr(2*sandwiches + 17*pickles + 14*cornichons >= 24, "calcium_constraint5")
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 24, "calcium_constraint6")
m.addConstr(9*bananas + 2*sandwiches + 14*cornichons >= 24, "calcium_constraint7")
m.addConstr(9*bananas + 2*sandwiches + 17*pickles >= 24, "calcium_constraint8")
m.addConstr(2*sandwiches + 17*pickles + 14*cornichons >= 27, "calcium_constraint9")
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27, "calcium_constraint10")
m.addConstr(9*bananas + 2*sandwiches + 14*cornichons >= 27, "calcium_constraint11")
m.addConstr(9*bananas + 2*sandwiches + 17*pickles >= 27, "calcium_constraint12")
m.addConstr(2*sandwiches + 17*pickles + 14*cornichons >= 35, "calcium_constraint13")
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 35, "calcium_constraint14")
m.addConstr(9*bananas + 2*sandwiches + 14*cornichons >= 35, "calcium_constraint15")
m.addConstr(9*bananas + 2*sandwiches + 17*pickles >= 35, "calcium_constraint16")
m.addConstr(2*sandwiches + 17*pickles + 14*cornichons >= 27, "calcium_constraint17") # Duplicate constraint
m.addConstr(11*oranges + 17*pickles + 14*cornichons >= 27, "calcium_constraint18") # Duplicate constraint
m.addConstr(9*bananas + 2*sandwiches + 14*cornichons >= 27, "calcium_constraint19") # Duplicate constraint
m.addConstr(9*bananas + 2*sandwiches + 17*pickles >= 27, "calcium_constraint20") # Duplicate constraint
m.addConstr(11*oranges + 14*cornichons <= 55, "calcium_constraint21")
m.addConstr(2*sandwiches + 14*cornichons <= 158, "calcium_constraint22")
m.addConstr(11*oranges + 17*pickles <= 154, "calcium_constraint23")
m.addConstr(17*pickles + 14*cornichons <= 122, "calcium_constraint24")
m.addConstr(11*oranges + 2*sandwiches <= 204, "calcium_constraint25")
m.addConstr(2*sandwiches + 17*pickles <= 119, "calcium_constraint26")
m.addConstr(11*oranges + 2*sandwiches + 17*pickles <= 85, "calcium_constraint27")
m.addConstr(11*oranges + 9*bananas + 2*sandwiches + 17*pickles + 14*cornichons <= 85, "calcium_constraint28")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    for v in m.getVars():
        print('%s %g' % (v.varName, v.x))
elif m.status == gp.GRB.INFEASIBLE:
    print("The model is infeasible.")
else:
    print("Optimization ended with status %d" % m.status)

