
import gurobipy as gp

# Create a new model
m = gp.Model("WorkAllocation")

# Create variables
hank_hours = m.addVar(name="hank_hours", nonneg=True)
paul_hours = m.addVar(name="paul_hours", nonneg=True)
mary_hours = m.addVar(name="mary_hours", nonneg=True)

# Set objective function
m.setObjective(2 * hank_hours + 7 * paul_hours + 7 * mary_hours, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * hank_hours + 3 * mary_hours >= 41, "c1")
m.addConstr(21 * paul_hours + 13 * mary_hours >= 33, "c2")
m.addConstr(7 * hank_hours + 13 * mary_hours >= 29, "c3")
m.addConstr(7 * hank_hours + 21 * paul_hours + 13 * mary_hours >= 73, "c4")
m.addConstr(15 * hank_hours + 7 * mary_hours >= 84, "c5")
m.addConstr(15 * hank_hours + 5 * paul_hours >= 83, "c6")
m.addConstr(5 * paul_hours + 7 * mary_hours >= 64, "c7")
m.addConstr(2 * hank_hours + 7 * mary_hours >= 15, "c8")
m.addConstr(4 * paul_hours + 7 * mary_hours >= 22, "c9")
m.addConstr(2 * hank_hours + 4 * paul_hours + 7 * mary_hours >= 29, "c10")

m.addConstr(16 * hank_hours + 16 * paul_hours <= 72, "c11")
m.addConstr(16 * hank_hours + 3 * mary_hours <= 152, "c12")
m.addConstr(16 * paul_hours + 3 * mary_hours <= 110, "c13")
m.addConstr(16 * hank_hours + 16 * paul_hours + 3 * mary_hours <= 110, "c14")
m.addConstr(17 * paul_hours + 2 * mary_hours <= 106, "c15")
m.addConstr(11 * hank_hours + 17 * paul_hours + 2 * mary_hours <= 106, "c16")
m.addConstr(7 * hank_hours + 21 * paul_hours <= 211, "c17")
m.addConstr(21 * paul_hours + 13 * mary_hours <= 159, "c18")
m.addConstr(7 * hank_hours + 21 * paul_hours + 13 * mary_hours <= 159, "c19")
m.addConstr(5 * paul_hours + 7 * mary_hours <= 210, "c20")
m.addConstr(15 * hank_hours + 5 * paul_hours <= 202, "c21")
m.addConstr(15 * hank_hours + 5 * paul_hours + 7 * mary_hours <= 202, "c22")
m.addConstr(4 * paul_hours + 7 * mary_hours <= 107, "c23")
m.addConstr(2 * hank_hours + 4 * paul_hours + 7 * mary_hours <= 107, "c24")


# Optimize model
m.optimize()

# Print results
if m.status == gp.GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('Hank Hours: %g' % hank_hours.x)
    print('Paul Hours: %g' % paul_hours.x)
    print('Mary Hours: %g' % mary_hours.x)
elif m.status == gp.GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
