
import gurobi as gp

# Create a new model
m = gp.Model("optimization_problem")

# Define the variables
hours_worked_by_Hank = m.addVar(name="hours_worked_by_Hank", lb=0)
hours_worked_by_Paul = m.addVar(name="hours_worked_by_Paul", lb=0)
hours_worked_by_Mary = m.addVar(name="hours_worked_by_Mary", lb=0)

# Define the objective function
m.setObjective(2 * hours_worked_by_Hank + 7 * hours_worked_by_Paul + 7 * hours_worked_by_Mary, gp.GRB.MAXIMIZE)

# Add constraints
m.addConstr(16 * hours_worked_by_Hank <= 169)
m.addConstr(11 * hours_worked_by_Hank <= 316)
m.addConstr(7 * hours_worked_by_Hank <= 223)
m.addConstr(15 * hours_worked_by_Hank <= 263)
m.addConstr(2 * hours_worked_by_Hank <= 131)

m.addConstr(16 * hours_worked_by_Paul <= 169)
m.addConstr(17 * hours_worked_by_Paul <= 316)
m.addConstr(21 * hours_worked_by_Paul <= 223)
m.addConstr(5 * hours_worked_by_Paul <= 263)
m.addConstr(4 * hours_worked_by_Paul <= 131)

m.addConstr(3 * hours_worked_by_Mary <= 169)
m.addConstr(2 * hours_worked_by_Mary <= 316)
m.addConstr(13 * hours_worked_by_Mary <= 223)
m.addConstr(7 * hours_worked_by_Mary <= 263)
m.addConstr(7 * hours_worked_by_Mary <= 131)

m.addConstr(16 * hours_worked_by_Hank + 3 * hours_worked_by_Mary >= 41)
m.addConstr(21 * hours_worked_by_Paul + 13 * hours_worked_by_Mary >= 33)
m.addConstr(7 * hours_worked_by_Hank + 13 * hours_worked_by_Mary >= 29)
m.addConstr(7 * hours_worked_by_Hank + 21 * hours_worked_by_Paul + 13 * hours_worked_by_Mary >= 73)
m.addConstr(15 * hours_worked_by_Hank + 7 * hours_worked_by_Mary >= 84)
m.addConstr(15 * hours_worked_by_Hank + 5 * hours_worked_by_Paul >= 83)
m.addConstr(5 * hours_worked_by_Paul + 7 * hours_worked_by_Mary >= 64)
m.addConstr(2 * hours_worked_by_Hank + 7 * hours_worked_by_Mary >= 15)
m.addConstr(4 * hours_worked_by_Paul + 7 * hours_worked_by_Mary >= 22)
m.addConstr(2 * hours_worked_by_Hank + 4 * hours_worked_by_Paul + 7 * hours_worked_by_Mary >= 29)

m.addConstr(16 * hours_worked_by_Hank + 16 * hours_worked_by_Paul <= 72)
m.addConstr(16 * hours_worked_by_Hank + 3 * hours_worked_by_Mary <= 152)
m.addConstr(16 * hours_worked_by_Paul + 3 * hours_worked_by_Mary <= 110)
m.addConstr(16 * hours_worked_by_Hank + 16 * hours_worked_by_Paul + 3 * hours_worked_by_Mary <= 110)
m.addConstr(17 * hours_worked_by_Paul + 2 * hours_worked_by_Mary <= 106)
m.addConstr(11 * hours_worked_by_Hank + 17 * hours_worked_by_Paul + 2 * hours_worked_by_Mary <= 106)
m.addConstr(7 * hours_worked_by_Hank + 21 * hours_worked_by_Paul <= 211)
m.addConstr(21 * hours_worked_by_Paul + 13 * hours_worked_by_Mary <= 159)
m.addConstr(7 * hours_worked_by_Hank + 21 * hours_worked_by_Paul + 13 * hours_worked_by_Mary <= 159)
m.addConstr(5 * hours_worked_by_Paul + 7 * hours_worked_by_Mary <= 210)
m.addConstr(15 * hours_worked_by_Hank + 5 * hours_worked_by_Paul <= 202)
m.addConstr(15 * hours_worked_by_Hank + 5 * hours_worked_by_Paul + 7 * hours_worked_by_Mary <= 202)
m.addConstr(4 * hours_worked_by_Paul + 7 * hours_worked_by_Mary <= 107)
m.addConstr(2 * hours_worked_by_Hank + 4 * hours_worked_by_Paul + 7 * hours_worked_by_Mary <= 107)

# Solve the model
m.optimize()

# Print the results
if m.status == gp.GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Hank: {hours_worked_by_Hank.varValue}")
    print(f"Hours worked by Paul: {hours_worked_by_Paul.varValue}")
    print(f"Hours worked by Mary: {hours_worked_by_Mary.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
