
from gurobipy import Model, GRB

# Create a new model
model = Model("Minimize Employee Cost")

# Create variables
dale_hours = model.addVar(vtype=GRB.CONTINUOUS, name="dale_hours")
peggy_hours = model.addVar(vtype=GRB.CONTINUOUS, name="peggy_hours")

# Set objective function
model.setObjective(6.93 * dale_hours + 5.9 * peggy_hours, GRB.MINIMIZE)

# Add constraints

# Redundant constraints removed (e.g., "at minimum" and "or more" express the same inequality)

model.addConstr(8 * dale_hours + 8 * peggy_hours >= 44, "total_likelihood_min")
model.addConstr(8 * dale_hours + 8 * peggy_hours <= 62, "total_likelihood_max")

model.addConstr(1 * dale_hours + 3 * peggy_hours >= 101, "total_org_score_min")
model.addConstr(1 * dale_hours + 3 * peggy_hours <= 233, "total_org_score_max")

model.addConstr(12 * dale_hours + 13 * peggy_hours >= 86, "total_productivity_min")
model.addConstr(12 * dale_hours + 13 * peggy_hours <= 132, "total_productivity_max")

model.addConstr(4 * dale_hours - 8 * peggy_hours >= 0, "dale_peggy_relation")


# Optimize model
model.optimize()

# Print results
if model.status == GRB.OPTIMAL:
    print('Optimal solution found:')
    print(f'Dale Hours: {dale_hours.x}')
    print(f'Peggy Hours: {peggy_hours.x}')
    print(f'Objective Value: {model.objVal}')
elif model.status == GRB.INFEASIBLE:
    print('Model is infeasible.')
else:
    print(f'Optimization ended with status: {model.status}')

