
from gurobipy import *

# Create a new model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Dale")
x1 = m.addVar(vtype=GRB.CONTINUOUS, name="hours_worked_by_Peggy")

# Objective function: Minimize 6.93*x0 + 5.9*x1
m.setObjective(6.93*x0 + 5.9*x1, GRB.MINIMIZE)

# Constraints
m.addConstr(8*x0 + 8*x1 >= 44, "Combined_likelihood_to_quit_index_minimum")
m.addConstr(8*x0 + 8*x1 <= 62, "Combined_likelihood_to_quit_index_maximum")

m.addConstr(x0 + 3*x1 >= 101, "Combined_organization_score_minimum")
m.addConstr(x0 + 3*x1 <= 233, "Combined_organization_score_maximum")

m.addConstr(12*x0 + 13*x1 >= 86, "Combined_productivity_rating_minimum")
m.addConstr(12*x0 + 13*x1 <= 132, "Combined_productivity_rating_maximum")

m.addConstr(4*x0 - 8*x1 >= 0, "Additional_constraint")

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Hours worked by Dale: {x0.x}")
    print(f"Hours worked by Peggy: {x1.x}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")

