
import gurobi

def solve_optimization_problem():
    # Create a new Gurobi model
    model = gurobi.Model()

    # Define variables
    dale_hours = model.addVar(lb=0, name="dale_hours")  # hours worked by Dale
    peggy_hours = model.addVar(lb=0, name="peggy_hours")  # hours worked by Peggy

    # Objective function: Minimize 6.93 * dale_hours + 5.9 * peggy_hours
    model.setObjective(6.93 * dale_hours + 5.9 * peggy_hours, gurobi.GRB.MINIMIZE)

    # Constraints
    # Individual constraints (these are actually bounds on the variables, not constraints)
    # Dale's constraints
    model.addConstraint(dale_hours * 8 <= 94, name="dale_likelihood_quit")
    model.addConstraint(dale_hours * 1 <= 290, name="dale_organization_score")
    model.addConstraint(dale_hours * 12 <= 242, name="dale_productivity_rating")

    # Peggy's constraints
    model.addConstraint(peggy_hours * 8 <= 94, name="peggy_likelihood_quit")
    model.addConstraint(peggy_hours * 3 <= 290, name="peggy_organization_score")
    model.addConstraint(peggy_hours * 13 <= 242, name="peggy_productivity_rating")

    # Combined constraints
    model.addConstraint(dale_hours * 8 + peggy_hours * 8 >= 44, name="combined_likelihood_quit_min")
    model.addConstraint(dale_hours * 8 + peggy_hours * 8 <= 62, name="combined_likelihood_quit_max")

    model.addConstraint(dale_hours * 1 + peggy_hours * 3 >= 101, name="combined_organization_score_min")
    model.addConstraint(dale_hours * 1 + peggy_hours * 3 <= 233, name="combined_organization_score_max")

    model.addConstraint(dale_hours * 12 + peggy_hours * 13 >= 86, name="combined_productivity_rating_min")
    model.addConstraint(dale_hours * 12 + peggy_hours * 13 <= 132, name="combined_productivity_rating_max")

    # Linear constraint
    model.addConstraint(4 * dale_hours - 8 * peggy_hours >= 0, name="linear_constraint")

    # Solve the model
    model.optimize()

    # Print the solution
    if model.status == gurobi.GRB.OPTIMAL:
        print("Optimal solution found.")
        print(f"Hours worked by Dale: {dale_hours.varValue}")
        print(f"Hours worked by Peggy: {peggy_hours.varValue}")
        print(f"Objective: {model.objVal}")
    elif model.status == gurobi.GRB.INFEASIBLE:
        print("No feasible solution exists.")
    else:
        print("Optimization failed.")

solve_optimization_problem()
