
from gurobipy import Model, GRB

# Create a new model
m = Model("optimization_problem")

# Create variables
bacon = m.addVar(vtype=GRB.INTEGER, name="bacon")
pizza = m.addVar(vtype=GRB.CONTINUOUS, name="pizza")
salad = m.addVar(vtype=GRB.CONTINUOUS, name="salad")

# Set objective function
m.setObjective(8.71 * bacon**2 + 3.39 * bacon * salad + 3.22 * pizza * salad + 2.28 * salad**2 + 7.59 * pizza + 6.1 * salad, GRB.MINIMIZE)

# Add constraints
m.addConstr(22 * bacon**2 + 13 * pizza**2 >= 45, "calcium_constraint1")
m.addConstr(13 * pizza**2 + 22 * salad**2 >= 52, "calcium_constraint2")
m.addConstr(22 * bacon + 13 * pizza + 22 * salad >= 52, "calcium_constraint3")

m.addConstr(2 * pizza + 7 * salad >= 38, "cost_constraint1")
m.addConstr(8 * bacon + 2 * pizza >= 22, "cost_constraint2")
m.addConstr(8 * bacon + 2 * pizza + 7 * salad >= 41, "cost_constraint3")

m.addConstr(20 * bacon**2 + 2 * salad**2 >= 106, "umami_constraint1")
m.addConstr(3 * pizza**2 + 2 * salad**2 >= 113, "umami_constraint2")
m.addConstr(20 * bacon**2 + 3 * pizza**2 >= 138, "umami_constraint3")
m.addConstr(20 * bacon**2 + 3 * pizza**2 + 2 * salad**2 >= 122, "umami_constraint4")
m.addConstr(20 * bacon + 3 * pizza + 2 * salad >= 122, "umami_constraint5")

m.addConstr(19 * pizza + 13 * salad >= 84, "tastiness_constraint1")
m.addConstr(17 * bacon + 13 * salad >= 101, "tastiness_constraint2")
m.addConstr(17 * bacon**2 + 19 * pizza**2 >= 95, "tastiness_constraint3")
m.addConstr(17 * bacon + 19 * pizza + 13 * salad >= 95, "tastiness_constraint4")


m.addConstr(bacon + 23 * pizza >= 57, "carbohydrate_constraint1")
m.addConstr(bacon + 11 * salad >= 44, "carbohydrate_constraint2")
m.addConstr(bacon + 23 * pizza + 11 * salad >= 44, "carbohydrate_constraint3")

m.addConstr(-10 * bacon + 9 * salad >= 0, "constraint1")
m.addConstr(-4 * pizza**2 + 5 * salad**2 >= 0, "constraint2")

m.addConstr(3 * pizza**2 + 2 * salad**2 <= 291, "umami_constraint6")
m.addConstr(20 * bacon + 2 * salad <= 218, "umami_constraint7")
m.addConstr(17 * bacon**2 + 13 * salad**2 <= 279, "tastiness_constraint5")
m.addConstr(bacon + 23 * pizza + 11 * salad <= 140, "carbohydrate_constraint4")


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('bacon:', bacon.x)
    print('pizza:', pizza.x)
    print('salad:', salad.x)
elif m.status == GRB.INFEASIBLE:
    print('The problem is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
