
from gurobipy import Model, GRB, quicksum

# Create a new model
m = Model("optimization_problem")

# Create variables
x0 = m.addVar(lb=0, vtype=GRB.CONTINUOUS, name="grams of carbohydrates")
x1 = m.addVar(lb=0, vtype=GRB.INTEGER, name="milligrams of vitamin B6")

# Set objective function
obj = 6.63 * x0**2 + 7.63 * x0 * x1 + 4.72 * x1**2 + 3.6 * x0 + 8.16 * x1
m.setObjective(obj, GRB.MAXIMIZE)

# Add constraints
m.addConstr(1 * x0 + 6 * x1 <= 90, "r0")  # Cognitive performance index
m.addConstr(2 * x0 + 1 * x1 <= 77, "r1")  # Kidney support index
m.addConstr(x0**2 + x1**2 >= 32, "c1")  # Combined cognitive performance index (squared) >= 32
m.addConstr(2 * x0**2 + x1**2 >= 33, "c2")  # Combined kidney support index (squared) >= 33
m.addConstr(8 * x0 - 7 * x1 >= 0, "c3")
m.addConstr(1 * x0 + 6 * x1 <= 78, "c4")  # Combined cognitive performance index <= 78
m.addConstr(2 * x0**2 + x1**2 <= 54, "c5")  # Combined kidney support index (squared) <= 54
m.addConstr(2 * x0 + 1 * x1 <= 54, "c6")  # Combined kidney support index <= 54


# Optimize model
m.optimize()

# Print results
if m.status == GRB.OPTIMAL:
    print('Obj: %g' % m.objVal)
    print('x0: %g' % x0.x)
    print('x1: %g' % x1.x)
elif m.status == GRB.INFEASIBLE:
    print('The model is infeasible.')
else:
    print('Optimization ended with status %d' % m.status)
