
from gurobipy import *

# Create a model
m = Model("Optimization_Problem")

# Define variables
x0 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.CONTINUOUS, name="grams_of_carbohydrates")
x1 = m.addVar(lb=-GRB.INFINITY, ub=GRB.INFINITY, vtype=GRB.INTEGER, name="milligrams_of_vitamin_B6")

# Objective function
m.setObjective(6.63*x0**2 + 7.63*x0*x1 + 4.72*x1**2 + 3.6*x0 + 8.16*x1, GRB.MAXIMIZE)

# Constraints
m.addConstr(x0**2 + 36*x1**2 >= 32)  # Cognitive performance index constraint adjusted for squared terms
m.addConstr(4*x0**2 + x1**2 >= 33)   # Kidney support index constraint adjusted for squared terms
m.addConstr(8*x0 - 7*x1 >= 0)
m.addConstr(x0 + 6*x1 <= 78)        # Adjusted cognitive performance index constraint
m.addConstr(4*x0**2 + x1**2 <= 54)   # Kidney support index constraint adjusted for squared terms
m.addConstr(x0 + x1 <= 54)           # Additional kidney support index constraint

# Optimize model
m.optimize()

# Print solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found:")
    print(f"Grams of carbohydrates: {x0.x}")
    print(f"Milligrams of vitamin B6: {x1.x}")
else:
    print("No optimal solution found.")
