
import gurobipy as gp
from gurobipy import GRB

# Create a new model
m = gp.Model("optimization_problem")

# Define variables
grams_carbohydrates = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="grams_carbohydrates")
milligrams_vitamin_B6 = m.addVar(lb=-gp.GRB.INFINITY, ub=gp.GRB.INFINITY, name="milligrams_vitamin_B6", vtype=GRB.INTEGER)

# Objective function
m.setObjective(6.63 * grams_carbohydrates**2 + 7.63 * grams_carbohydrates * milligrams_vitamin_B6 + 4.72 * milligrams_vitamin_B6**2 + 3.6 * grams_carbohydrates + 8.16 * milligrams_vitamin_B6, GRB.MAXIMIZE)

# Constraints
m.addConstr(grams_carbohydrates**2 + milligrams_vitamin_B6**2 >= 32, "cognitive_performance_index_squared")
m.addConstr(2 * grams_carbohydrates**2 + milligrams_vitamin_B6**2 >= 33, "kidney_support_index_squared")
m.addConstr(8 * grams_carbohydrates - 7 * milligrams_vitamin_B6 >= 0, "additional_constraint_1")
m.addConstr(grams_carbohydrates + 6 * milligrams_vitamin_B6 <= 78, "cognitive_performance_index_linear")
m.addConstr(2 * grams_carbohydrates + milligrams_vitamin_B6 <= 54, "kidney_support_index_linear")

# Solve the model
m.optimize()

# Print the solution
if m.status == GRB.OPTIMAL:
    print("Optimal solution found.")
    print(f"Grams of carbohydrates: {grams_carbohydrates.varValue}")
    print(f"Milligrams of vitamin B6: {milligrams_vitamin_B6.varValue}")
    print(f"Objective function value: {m.objVal}")
else:
    print("No optimal solution found.")
